/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core.spring;

import de.taimos.daemon.spring.annotations.ProdComponent;
import de.taimos.dvalin.interconnect.core.daemon.ADaemonMessageHandler;
import de.taimos.dvalin.interconnect.core.daemon.IdemponentRetryException;
import de.taimos.dvalin.interconnect.core.spring.IDaemonMessageHandlerFactory;
import javax.annotation.PostConstruct;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ErrorHandler;

@ProdComponent(value="messageListener")
public final class DaemonMessageListener
implements MessageListener,
ErrorHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDaemonMessageHandlerFactory messageHandlerFactory;
    private ADaemonMessageHandler handler;

    @PostConstruct
    public void start() {
        this.handler = this.messageHandlerFactory.create(this.logger);
    }

    public void onMessage(Message message) {
        try {
            this.handler.onMessage(message);
        }
        catch (IdemponentRetryException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Exception", (Throwable)e);
        }
    }

    public void handleError(Throwable e) {
        this.logger.warn("Exception, retry!", e);
    }
}

