/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core.event;

import de.taimos.daemon.spring.annotations.ProdComponent;
import de.taimos.dvalin.interconnect.core.MessageConnector;
import de.taimos.dvalin.interconnect.core.event.EventHandler;
import de.taimos.dvalin.interconnect.model.InterconnectMapper;
import de.taimos.dvalin.interconnect.model.InterconnectObject;
import de.taimos.dvalin.interconnect.model.event.EventDomain;
import de.taimos.dvalin.interconnect.model.event.IEvent;
import de.taimos.dvalin.interconnect.model.service.IEventHandler;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.listener.MessageListenerContainer;
import org.springframework.util.ErrorHandler;

@ProdComponent(value="eventMessageListener")
public class EventMessageListener
implements MessageListener,
ErrorHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${interconnect.jms.consumers:2-8}")
    private String consumers;
    @Value(value="${serviceName}")
    private String serviceName;
    @Value(value="${interconnect.jms.virtualtopic.prefix:VirtualTopic}")
    private String virtualTopicPrefix;
    @Value(value="${interconnect.jms.virtualtopic.consumerprefix:Consumer}")
    private String consumerPrefix;
    @Autowired
    @Qualifier(value="DvalinConnectionFactory")
    private ConnectionFactory jmsFactory;
    @Autowired
    private ApplicationContext applicationContext;
    private Set<IEventHandler> eventHandlers;
    private Set<MessageListenerContainer> listeners;

    @PostConstruct
    public void initEventListeners() {
        this.listeners = new HashSet<MessageListenerContainer>();
        this.eventHandlers = new HashSet<IEventHandler>();
        for (Object o : this.applicationContext.getBeansWithAnnotation(EventHandler.class).values()) {
            if (!(o instanceof IEventHandler)) continue;
            this.eventHandlers.add((IEventHandler)o);
        }
        for (String domain : this.getDomains()) {
            this.logger.info("Registered EventListener for topic {}", (Object)domain);
            DefaultMessageListenerContainer dmlc = this.createQueueListener(domain);
            this.listeners.add((MessageListenerContainer)dmlc);
        }
    }

    @PreDestroy
    public void stopEventListeners() {
        for (MessageListenerContainer listener : this.listeners) {
            listener.stop();
        }
    }

    public void onMessage(Message message) {
        try {
            if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                this.logger.debug("TextMessage received: {}", (Object)textMessage.getText());
                boolean secure = MessageConnector.isMessageSecure(textMessage);
                if (secure) {
                    MessageConnector.decryptMessage(textMessage);
                }
                InterconnectObject eventIn = InterconnectMapper.fromJson((String)textMessage.getText(), InterconnectObject.class);
                for (IEventHandler eventHandler : this.eventHandlers) {
                    if (eventHandler == null || !eventIn.getClass().isAssignableFrom(eventHandler.getEventType())) continue;
                    eventHandler.handleEvent((IEvent)eventIn);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Exception", (Throwable)e);
        }
    }

    public void handleError(Throwable throwable) {
        this.logger.warn("An error during event handling occured", throwable);
    }

    private DefaultMessageListenerContainer createQueueListener(String domain) {
        ActiveMQQueue virtualTopic = new ActiveMQQueue(this.consumerPrefix + "." + this.serviceName + "." + this.virtualTopicPrefix + "." + domain);
        DefaultMessageListenerContainer dmlc = new DefaultMessageListenerContainer();
        dmlc.setConnectionFactory(this.jmsFactory);
        dmlc.setErrorHandler((ErrorHandler)this);
        dmlc.setConcurrency(this.consumers);
        dmlc.setDestination((Destination)virtualTopic);
        dmlc.setMessageListener((Object)this);
        dmlc.afterPropertiesSet();
        dmlc.start();
        return dmlc;
    }

    private Collection<String> getDomains() {
        HashSet<String> result = new HashSet<String>();
        if (this.eventHandlers == null || this.eventHandlers.isEmpty()) {
            return result;
        }
        for (IEventHandler eventHandler : this.eventHandlers) {
            Annotation domainAnnotation;
            if (eventHandler == null || eventHandler.getEventType() == null || (domainAnnotation = AnnotationUtils.findAnnotation((Class)eventHandler.getEventType(), EventDomain.class)) == null || ((EventDomain)domainAnnotation).value().isEmpty()) continue;
            result.add(((EventDomain)domainAnnotation).value());
        }
        return result;
    }
}

