/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core.daemon;

import de.taimos.dvalin.interconnect.model.InterconnectObject;
import de.taimos.dvalin.interconnect.model.service.DaemonScanner;
import de.taimos.dvalin.interconnect.model.service.IDaemonHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DaemonMethodRegistry {
    private final Map<Class<? extends InterconnectObject>, RegistryEntry> registry;

    public DaemonMethodRegistry(Class<? extends IDaemonHandler> aHandlerClazz) {
        HashMap<Class, RegistryEntry> reg = new HashMap<Class, RegistryEntry>();
        for (DaemonScanner.DaemonMethod re : DaemonScanner.scan(aHandlerClazz)) {
            reg.put(re.getRequest(), new RegistryEntry(aHandlerClazz, re));
        }
        this.registry = Collections.unmodifiableMap(reg);
    }

    public DaemonMethodRegistry(Collection<Class<? extends IDaemonHandler>> aHandlerClazzes) {
        HashMap<Class, RegistryEntry> reg = new HashMap<Class, RegistryEntry>();
        for (Class<? extends IDaemonHandler> aHandlerClazz : aHandlerClazzes) {
            for (DaemonScanner.DaemonMethod re : DaemonScanner.scan(aHandlerClazz)) {
                reg.put(re.getRequest(), new RegistryEntry(aHandlerClazz, re));
            }
        }
        this.registry = Collections.unmodifiableMap(reg);
    }

    public RegistryEntry get(Class<? extends InterconnectObject> icoClass) {
        return this.registry.get(icoClass);
    }

    public DaemonScanner.DaemonMethod getMethod(Class<? extends InterconnectObject> icoClass) {
        RegistryEntry registryEntry = this.registry.get(icoClass);
        if (registryEntry == null) {
            return null;
        }
        return registryEntry.getMethod();
    }

    public static class RegistryEntry {
        private final Class<? extends IDaemonHandler> aHandlerClazz;
        private final DaemonScanner.DaemonMethod method;

        RegistryEntry(Class<? extends IDaemonHandler> aHandlerClazz, DaemonScanner.DaemonMethod method) {
            this.aHandlerClazz = aHandlerClazz;
            this.method = method;
        }

        public Class<? extends IDaemonHandler> getHandlerClazz() {
            return this.aHandlerClazz;
        }

        public DaemonScanner.DaemonMethod getMethod() {
            return this.method;
        }
    }
}

