/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core.config;

import de.taimos.daemon.spring.conditional.OnSystemProperty;
import de.taimos.dvalin.interconnect.core.spring.IDaemonMessageHandlerFactory;
import de.taimos.dvalin.interconnect.core.spring.IDaemonMessageSender;
import de.taimos.dvalin.interconnect.core.spring.MultiDaemonMessageHandler;
import de.taimos.dvalin.interconnect.core.spring.RequestHandler;
import de.taimos.dvalin.interconnect.model.service.IDaemonHandler;
import java.util.HashSet;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@OnSystemProperty(propertyName="interconnect.requesthandler.mode", propertyValue="multi")
public class MultiRequestHandlerConfig {
    @Bean
    @Primary
    public IDaemonMessageHandlerFactory createDaemonMessageHandlerFactory(ApplicationContext applicationContext, IDaemonMessageSender messageSender) {
        return logger -> {
            HashSet<Class<? extends IDaemonHandler>> handlers = new HashSet<Class<? extends IDaemonHandler>>();
            for (Object o : applicationContext.getBeansWithAnnotation(RequestHandler.class).values()) {
                if (!(o instanceof IDaemonHandler)) continue;
                handlers.add(((IDaemonHandler)o).getClass());
            }
            return new MultiDaemonMessageHandler(logger, handlers, messageSender, (BeanFactory)applicationContext.getAutowireCapableBeanFactory());
        };
    }
}

