/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core.config;

import de.taimos.dvalin.interconnect.core.ActiveMQPooledConnectionFactory;
import de.taimos.dvalin.interconnect.core.DvalinConnectionFactory;
import de.taimos.dvalin.interconnect.core.daemon.DaemonRequestResponse;
import de.taimos.dvalin.interconnect.core.daemon.IDaemonRequestResponse;
import de.taimos.dvalin.interconnect.core.spring.DaemonMessageListener;
import de.taimos.dvalin.interconnect.core.spring.IDaemonMessageHandlerFactory;
import de.taimos.dvalin.interconnect.core.spring.IDaemonMessageSender;
import de.taimos.dvalin.interconnect.core.spring.SingleDaemonMessageHandler;
import de.taimos.dvalin.interconnect.model.service.ADaemonHandler;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.jms.pool.PooledConnectionFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.Scope;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.util.ErrorHandler;

@Configuration
@Profile(value={"prod"})
@EnableTransactionManagement
public class JMSConfig {
    @Value(value="${interconnect.jms.broker}")
    private String brokerUrl;
    @Value(value="${interconnect.jms.consumers:2-8}")
    private String consumers;
    @Value(value="${serviceName}")
    private String serviceName;
    @Value(value="${interconnect.jms.userName:#{null}}")
    private String userName;
    @Value(value="${interconnect.jms.password:}")
    private String password;

    @Bean(name={"DvalinConnectionFactory"})
    public ConnectionFactory jmsConnectionFactory() {
        return new DvalinConnectionFactory(this.brokerUrl, this.userName, this.password);
    }

    @Bean(destroyMethod="stop")
    public PooledConnectionFactory jmsFactory(ConnectionFactory jmsConnectionFactory) {
        return new ActiveMQPooledConnectionFactory().initDefault(jmsConnectionFactory);
    }

    @Bean
    public JmsTemplate jmsTemplate(PooledConnectionFactory jmsFactory) {
        return new JmsTemplate((ConnectionFactory)jmsFactory);
    }

    @Bean
    public JmsTemplate topicJmsTemplate(PooledConnectionFactory jmsFactory) {
        JmsTemplate template = new JmsTemplate((ConnectionFactory)jmsFactory);
        template.setPubSubDomain(true);
        return template;
    }

    @Bean
    @Scope(value="singleton")
    public IDaemonRequestResponse requestResponse() {
        return new DaemonRequestResponse();
    }

    @Bean
    public IDaemonMessageHandlerFactory createDaemonMessageHandlerFactory(BeanFactory beanFactory, IDaemonMessageSender messageSender) {
        return logger -> {
            ADaemonHandler rh = (ADaemonHandler)beanFactory.getBean("requestHandler");
            return new SingleDaemonMessageHandler(logger, rh.getClass(), messageSender, beanFactory);
        };
    }

    @Bean
    public DefaultMessageListenerContainer jmsListenerContainer(@Qualifier(value="DvalinConnectionFactory") ConnectionFactory jmsFactory, DaemonMessageListener messageListener) {
        DefaultMessageListenerContainer dmlc = new DefaultMessageListenerContainer();
        dmlc.setConnectionFactory(jmsFactory);
        dmlc.setErrorHandler((ErrorHandler)messageListener);
        dmlc.setConcurrency(this.consumers);
        dmlc.setDestination((Destination)new ActiveMQQueue(this.serviceName + ".request"));
        dmlc.setMessageListener((Object)messageListener);
        return dmlc;
    }
}

