/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core;

import de.taimos.dvalin.interconnect.core.ActiveMQPooledConnectionFactory;
import de.taimos.dvalin.interconnect.core.DvalinConnectionFactory;
import java.io.IOException;
import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ToTopicSender {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected volatile PooledConnectionFactory pooledConnectionFactory = new ActiveMQPooledConnectionFactory().initDefault(new DvalinConnectionFactory());

    protected ToTopicSender() {
    }

    public void mqTeardown() {
        this.pooledConnectionFactory.stop();
    }

    protected Message getMessage(Serializable object, Session session) throws JMSException, IOException {
        return session.createObjectMessage(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(Serializable object, String topicName) {
        Connection connection = null;
        try {
            connection = this.pooledConnectionFactory.createConnection();
            Session session = null;
            try {
                session = connection.createSession(false, 1);
                Topic topic = session.createTopic(topicName);
                MessageProducer topicmp = null;
                try {
                    topicmp = session.createProducer((Destination)topic);
                    topicmp.setDeliveryMode(1);
                    topicmp.send(this.getMessage(object, session));
                }
                finally {
                    if (topicmp != null) {
                        try {
                            topicmp.close();
                        }
                        catch (JMSException e) {
                            this.logger.warn("Can not close producer", (Throwable)e);
                        }
                    }
                }
            }
            finally {
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (JMSException e) {
                        this.logger.warn("Can not close session", (Throwable)e);
                    }
                }
            }
        }
        catch (IOException | JMSException e) {
            this.logger.error("Can not send message", e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    this.logger.warn("Can not close connection", (Throwable)e);
                }
            }
        }
    }
}

