/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core;

import de.taimos.dvalin.interconnect.core.ActiveMQPooledConnectionFactory;
import de.taimos.dvalin.interconnect.core.DvalinConnectionFactory;
import de.taimos.dvalin.interconnect.core.exceptions.InfrastructureException;
import de.taimos.dvalin.interconnect.core.exceptions.SerializationException;
import de.taimos.dvalin.interconnect.model.CryptoException;
import de.taimos.dvalin.interconnect.model.MessageCryptoUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageConnector {
    public static final String SYSPROP_UPDATE_TOPIC = "interconnect.jms.updatetopic";
    public static final String SYSPROP_VIRTUAL_TOPIC_PREFIX = "interconnect.jms.virtualtopic.prefix";
    public static final long REQUEST_TIMEOUT = 10000L;
    public static final int MSGPRIORITY = 5;
    private static final String SECURITY_CHECK_FAILED = "Message security check failed";
    private static final String INVALID_RESPONSE_MESSAGE_RECEIVED = "Invalid response message received";
    private static final String RECEIVE_FAILED = "Error while receiving messages";
    private static final String SEND_FAILED = "Error while sending messages";
    private static final String FAILED_TO_CREATE_MESSAGE = "Failed to create message";
    private static final String CONNECTION_START_FAIL = "Failed to connect to the Interconnect.";
    private static final String CONNECTION_STOP_FAIL = "Failed to close the connection to the Interconnect.";
    private static final String CONNECTION_NOT_READY = "Connection not yet initialized.";
    private static final String CAN_NOT_CREATE_SESSION = "Can not create session";
    private static final String CAN_NOT_CREATE_CONNECTION = "Can not create connection";
    private static final String CAN_NOT_CREATE_DESTINATION = "Can not create destination";
    private static final String CAN_NOT_CREATE_REPLY_TO_DESTINATION = "Can not create eply to destination";
    private static final String CAN_NOT_CREATE_CONSUMER = "Can not create consumer";
    private static final String CAN_NOT_CREATE_PRODUCER = "Can not create producer";
    private static volatile PooledConnectionFactory pooledConnectionFactory;
    private static final AtomicBoolean started;
    private static final Logger logger;

    private MessageConnector() {
    }

    public static void start() throws InfrastructureException {
        MessageConnector.start(System.getProperty("interconnect.jms.broker"));
    }

    private static ExceptionListener createMqErrorListener() {
        return new ExceptionListener(){

            public void onException(JMSException e) {
                logger.warn("ActiveMQ connection factory error", (Throwable)e);
            }
        };
    }

    public static void start(String brokerUrl) throws InfrastructureException {
        if (started.compareAndSet(false, true)) {
            DvalinConnectionFactory dvalinConnectionFactory = new DvalinConnectionFactory(brokerUrl);
            dvalinConnectionFactory.setExceptionListener(MessageConnector.createMqErrorListener());
            pooledConnectionFactory = new ActiveMQPooledConnectionFactory().initDefault(dvalinConnectionFactory);
        }
    }

    public static void start(String brokerUrl, String userName, String password) throws InfrastructureException {
        if (started.compareAndSet(false, true)) {
            DvalinConnectionFactory dvalinConnectionFactory = new DvalinConnectionFactory(brokerUrl, userName, password);
            dvalinConnectionFactory.setExceptionListener(MessageConnector.createMqErrorListener());
            pooledConnectionFactory = new ActiveMQPooledConnectionFactory().initDefault(dvalinConnectionFactory);
        }
    }

    public static void stop() throws InfrastructureException {
        if (started.compareAndSet(true, false)) {
            try {
                pooledConnectionFactory.stop();
                pooledConnectionFactory = null;
            }
            catch (Exception e) {
                throw new InfrastructureException(CONNECTION_STOP_FAIL, e);
            }
        }
    }

    private static void sendToDestination(GetDestinationAction getDestinationAction, String body, Map<String, Object> headers, boolean secure, String replyToQueueName, String correlationId) throws InfrastructureException, CryptoException {
        MessageConnector.checkInit();
        Connection connection = null;
        try {
            connection = pooledConnectionFactory.createConnection();
            Session session = null;
            try {
                Destination destination;
                TextMessage txt;
                session = connection.createSession(false, 1);
                try {
                    txt = session.createTextMessage(body);
                    if (replyToQueueName != null) {
                        try {
                            Queue replyTo = session.createQueue(replyToQueueName);
                            txt.setJMSReplyTo((Destination)replyTo);
                        }
                        catch (JMSException e) {
                            throw new InfrastructureException(CAN_NOT_CREATE_REPLY_TO_DESTINATION, e);
                        }
                    }
                    if (correlationId != null) {
                        txt.setJMSCorrelationID(correlationId);
                    }
                    if (headers != null) {
                        Set<Map.Entry<String, Object>> entrySet = headers.entrySet();
                        for (Map.Entry<String, Object> entry : entrySet) {
                            txt.setObjectProperty(entry.getKey(), entry.getValue());
                        }
                    }
                    if (secure) {
                        MessageConnector.secureMessage(txt);
                    }
                }
                catch (JMSException e) {
                    throw new SerializationException(FAILED_TO_CREATE_MESSAGE, e);
                }
                try {
                    destination = getDestinationAction.get(session);
                }
                catch (JMSException e) {
                    throw new InfrastructureException(CAN_NOT_CREATE_DESTINATION, e);
                }
                MessageProducer producer = null;
                try {
                    producer = session.createProducer(destination);
                    try {
                        producer.send((Message)txt);
                    }
                    catch (JMSException e) {
                        throw new InfrastructureException(SEND_FAILED, e);
                    }
                }
                catch (JMSException e) {
                    throw new InfrastructureException(CAN_NOT_CREATE_PRODUCER, e);
                }
                finally {
                    try {
                        if (producer != null) {
                            producer.close();
                        }
                    }
                    catch (JMSException e) {
                        logger.warn("Can not close producer", (Throwable)e);
                    }
                }
            }
            catch (JMSException e) {
                throw new InfrastructureException(CAN_NOT_CREATE_SESSION, e);
            }
            finally {
                try {
                    if (session != null) {
                        session.close();
                    }
                }
                catch (JMSException e) {
                    logger.warn("Can not close session", (Throwable)e);
                }
            }
        }
        catch (JMSException e) {
            throw new InfrastructureException(CAN_NOT_CREATE_CONNECTION, e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (JMSException e) {
                logger.warn("Can not close connection", (Throwable)e);
            }
        }
    }

    private static void sendToDestination(boolean isQueue, String destinationName, String body, Map<String, Object> headers, boolean secure, String replyToQueueName, String correlationId) throws InfrastructureException, CryptoException {
        MessageConnector.sendToDestination(new GetResolveDestinationAction(isQueue, destinationName), body, headers, secure, replyToQueueName, correlationId);
    }

    public static void sendToDestination(Destination destination, String body, Map<String, Object> headers, boolean secure, String replyToQueueName, String correlationId) throws InfrastructureException, CryptoException {
        MessageConnector.sendToDestination(new GetSimpleDestinationAction(destination), body, headers, secure, replyToQueueName, correlationId);
    }

    public static void sendToQueue(String queueName, String body, Map<String, Object> headers, boolean secure, String replyToQueueName, String correlationId) throws InfrastructureException, CryptoException {
        MessageConnector.sendToDestination(true, queueName, body, headers, secure, replyToQueueName, correlationId);
    }

    public static void sendToQueue(String queueName, String body, Map<String, Object> headers, boolean secure) throws InfrastructureException, CryptoException {
        MessageConnector.sendToQueue(queueName, body, headers, secure, null, null);
    }

    public static void sendToQueue(String queueName, String body, Map<String, Object> headers, String replyToQueueName, String correlationId) throws InfrastructureException {
        try {
            MessageConnector.sendToQueue(queueName, body, headers, false, replyToQueueName, correlationId);
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
    }

    public static void sendToQueue(String queueName, String body, Map<String, Object> headers) throws InfrastructureException {
        try {
            MessageConnector.sendToQueue(queueName, body, headers, false);
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
    }

    public static void sendToTopic(String topicName, String body, Map<String, Object> headers, boolean secure) throws InfrastructureException, CryptoException {
        MessageConnector.sendToDestination(false, topicName, body, headers, secure, null, null);
    }

    public static void sendToTopic(String topicName, String body, Map<String, Object> headers) throws InfrastructureException {
        try {
            MessageConnector.sendToTopic(topicName, body, headers, false);
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
    }

    @Deprecated
    public static TextMessage receive(String queueName, String selector, long timeout, boolean secure) throws InfrastructureException, CryptoException {
        return MessageConnector.receiveFromQueue(queueName, selector, timeout, secure);
    }

    /*
     * Exception decompiling
     */
    private static List<TextMessage> receiveBulkFromDestination(GetDestinationAction getDestinationAction, String selector, int maxSize, long timeout, boolean secure) throws InfrastructureException, CryptoException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static TextMessage receiveFromDestination(GetDestinationAction getDestinationAction, String selector, long timeout, boolean secure) throws InfrastructureException, CryptoException {
        List<TextMessage> messages = MessageConnector.receiveBulkFromDestination(getDestinationAction, selector, 1, timeout, secure);
        if (messages.size() != 1) {
            throw new InfrastructureException(RECEIVE_FAILED);
        }
        return messages.get(0);
    }

    public static TextMessage receiveFromQueue(String queueName, String selector, long timeout, boolean secure) throws InfrastructureException, CryptoException {
        return MessageConnector.receiveFromDestination(new GetResolveDestinationAction(true, queueName), selector, timeout, secure);
    }

    public static List<TextMessage> receiveBulkFromQueue(String queueName, String selector, int maxSize, long timeout, boolean secure) throws InfrastructureException, CryptoException {
        return MessageConnector.receiveBulkFromDestination(new GetResolveDestinationAction(true, queueName), selector, maxSize, timeout, secure);
    }

    public static TextMessage receiveFromTopic(String topicName, String selector, long timeout, boolean secure) throws InfrastructureException, CryptoException {
        return MessageConnector.receiveFromDestination(new GetResolveDestinationAction(false, topicName), selector, timeout, secure);
    }

    public static List<TextMessage> receiveBulkFromTopic(String topicName, String selector, int maxSize, long timeout, boolean secure) throws InfrastructureException, CryptoException {
        return MessageConnector.receiveBulkFromDestination(new GetResolveDestinationAction(false, topicName), selector, maxSize, timeout, secure);
    }

    /*
     * Exception decompiling
     */
    public static TextMessage request(String queueName, String body, Map<String, Object> headers, boolean secure, long receiveTimeout, long sendTimeout, int priority) throws InfrastructureException, CryptoException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static TextMessage request(String queueName, String body, Map<String, Object> headers) throws InfrastructureException {
        try {
            return MessageConnector.request(queueName, body, headers, false, 10000L, 10000L, 5);
        }
        catch (CryptoException cryptoException) {
            return null;
        }
    }

    public static boolean isMessageSecure(TextMessage txt) throws CryptoException, InfrastructureException {
        try {
            return txt.propertyExists("Signature");
        }
        catch (JMSException e) {
            throw new InfrastructureException(SECURITY_CHECK_FAILED, e);
        }
    }

    public static void decryptMessage(TextMessage txt) throws CryptoException {
        try {
            if (!txt.propertyExists("Signature")) {
                throw new CryptoException(SECURITY_CHECK_FAILED);
            }
            String signature = txt.getStringProperty("Signature");
            boolean validate = MessageCryptoUtil.validate((String)txt.getText(), (String)signature);
            if (!validate) {
                throw new CryptoException(SECURITY_CHECK_FAILED);
            }
            if (txt instanceof ActiveMQTextMessage) {
                ActiveMQTextMessage t = (ActiveMQTextMessage)txt;
                t.setReadOnlyBody(false);
            }
            String decryptedText = MessageCryptoUtil.decrypt((String)txt.getText());
            txt.setText(decryptedText);
        }
        catch (JMSException e) {
            throw new CryptoException(SECURITY_CHECK_FAILED, (Throwable)e);
        }
    }

    public static void secureMessage(TextMessage txt) throws JMSException, CryptoException {
        String cryptedText = MessageCryptoUtil.crypt((String)txt.getText());
        txt.setText(cryptedText);
        txt.setStringProperty("Signature", MessageCryptoUtil.sign((String)cryptedText));
    }

    private static void checkInit() throws InfrastructureException {
        if (!started.get()) {
            throw new InfrastructureException(CONNECTION_NOT_READY);
        }
    }

    static {
        started = new AtomicBoolean(false);
        logger = LoggerFactory.getLogger(MessageConnector.class);
    }

    private static final class GetSimpleDestinationAction
    implements GetDestinationAction {
        private final Destination destination;

        public GetSimpleDestinationAction(Destination destination) {
            this.destination = destination;
        }

        @Override
        public Destination get(Session session) throws JMSException {
            return this.destination;
        }
    }

    private static final class GetResolveDestinationAction
    implements GetDestinationAction {
        private final boolean isQueue;
        private final String destinationName;

        public GetResolveDestinationAction(boolean isQueue, String destinationName) {
            this.isQueue = isQueue;
            this.destinationName = destinationName;
        }

        @Override
        public Destination get(Session session) throws JMSException {
            if (this.isQueue) {
                return session.createQueue(this.destinationName);
            }
            return session.createTopic(this.destinationName);
        }
    }

    private static interface GetDestinationAction {
        public Destination get(Session var1) throws JMSException;
    }
}

