/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core;

import de.taimos.dvalin.interconnect.core.ToTopicSender;
import de.taimos.dvalin.interconnect.model.InterconnectMapper;
import de.taimos.dvalin.interconnect.model.InterconnectObject;
import de.taimos.dvalin.interconnect.model.event.EventDomain;
import de.taimos.dvalin.interconnect.model.event.IEvent;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.springframework.core.annotation.AnnotationUtils;

public class EventSender
extends ToTopicSender {
    private static final String PROP_DEFAULT_VIRTUAL_TOPIC_PREFIX = "VirtualTopic";
    private static EventSender instance = new EventSender();
    private String virtualTopicPrefix = System.getProperty("interconnect.jms.virtualtopic.prefix", "VirtualTopic");

    private EventSender() {
    }

    public static EventSender getInstance() {
        return instance;
    }

    @Override
    public void send(Serializable object, String topicName) {
        if (object instanceof IEvent) {
            this.send((IEvent)object);
        } else {
            super.send(object, topicName);
        }
    }

    public void send(IEvent object) {
        Annotation domainAnnotation = AnnotationUtils.findAnnotation(object.getClass(), EventDomain.class);
        if (domainAnnotation == null) {
            this.logger.error("The event {} has no domain annotation", (Object)object.getClass().getSimpleName());
            return;
        }
        if (((EventDomain)domainAnnotation).value().isEmpty()) {
            this.logger.error("The domainname for the event {} is empty", (Object)object.getClass().getSimpleName());
            return;
        }
        super.send((Serializable)object, this.virtualTopicPrefix + "." + ((EventDomain)domainAnnotation).value());
    }

    @Override
    protected Message getMessage(Serializable object, Session session) throws JMSException, IOException {
        if (object instanceof IEvent) {
            String json = InterconnectMapper.toJson((InterconnectObject)((IEvent)object));
            return session.createTextMessage(json);
        }
        return session.createObjectMessage(object);
    }
}

