/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ClientInternalExceptionListener;
import org.apache.activemq.transport.TransportListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.connection.UserCredentialsConnectionFactoryAdapter;

public class DvalinConnectionFactory
implements ConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DvalinConnectionFactory.class);
    public static final String SYSPROP_USERNAME = "interconnect.jms.userName";
    public static final String SYSPROP_PASSWORD = "interconnect.jms.password";
    public static final String SYSPROP_IBROKERURL = "interconnect.jms.broker";
    private ConnectionFactory innerFactory;
    private ConnectionFactory innerAdapter;
    private final String brokerURL;
    private final String userName;
    private final String password;

    public DvalinConnectionFactory() {
        String brokerURL = System.getProperty(SYSPROP_IBROKERURL);
        if (brokerURL == null) {
            LOGGER.warn("No interconnect.jms.broker configured, using tcp://localhost:61616.");
            brokerURL = "tcp://localhost:61616";
        }
        this.userName = System.getProperty(SYSPROP_USERNAME);
        this.password = System.getProperty(SYSPROP_PASSWORD);
        this.brokerURL = brokerURL;
        this.init();
    }

    public DvalinConnectionFactory(String brokerURL) {
        this.userName = System.getProperty(SYSPROP_USERNAME);
        this.password = System.getProperty(SYSPROP_PASSWORD);
        this.brokerURL = brokerURL;
        this.init();
    }

    public DvalinConnectionFactory(String brokerURL, String userName, String password) {
        this.userName = userName;
        this.password = password;
        this.brokerURL = brokerURL;
        this.init();
    }

    private void init() {
        this.innerFactory = new ActiveMQConnectionFactory(this.brokerURL);
        if (this.userName == null || this.userName.isEmpty()) {
            this.innerAdapter = this.innerFactory;
            return;
        }
        UserCredentialsConnectionFactoryAdapter credentialConnectionFactory = new UserCredentialsConnectionFactoryAdapter();
        credentialConnectionFactory.setTargetConnectionFactory(this.innerFactory);
        credentialConnectionFactory.setUsername(this.userName);
        credentialConnectionFactory.setPassword(this.password);
        this.innerAdapter = credentialConnectionFactory;
    }

    public void setExceptionListener(ExceptionListener listener) {
        if (this.innerAdapter instanceof ActiveMQConnectionFactory) {
            ((ActiveMQConnectionFactory)this.innerAdapter).setExceptionListener(listener);
        } else if (this.innerAdapter instanceof UserCredentialsConnectionFactoryAdapter && this.innerFactory instanceof ActiveMQConnectionFactory) {
            ((ActiveMQConnectionFactory)this.innerFactory).setExceptionListener(listener);
        }
    }

    public void setTrustAllPackages(boolean trustAllPackages) {
        if (this.innerAdapter instanceof ActiveMQConnectionFactory) {
            ((ActiveMQConnectionFactory)this.innerAdapter).setTrustAllPackages(trustAllPackages);
        } else if (this.innerAdapter instanceof UserCredentialsConnectionFactoryAdapter && this.innerFactory instanceof ActiveMQConnectionFactory) {
            ((ActiveMQConnectionFactory)this.innerFactory).setTrustAllPackages(trustAllPackages);
        }
    }

    public void setClientInternalExceptionListener(ClientInternalExceptionListener listener) {
        if (this.innerAdapter instanceof ActiveMQConnectionFactory) {
            ((ActiveMQConnectionFactory)this.innerAdapter).setClientInternalExceptionListener(listener);
        } else if (this.innerAdapter instanceof UserCredentialsConnectionFactoryAdapter && this.innerFactory instanceof ActiveMQConnectionFactory) {
            ((ActiveMQConnectionFactory)this.innerFactory).setClientInternalExceptionListener(listener);
        }
    }

    public void setTransportListener(TransportListener listener) {
        if (this.innerAdapter instanceof ActiveMQConnectionFactory) {
            ((ActiveMQConnectionFactory)this.innerAdapter).setTransportListener(listener);
        } else if (this.innerAdapter instanceof UserCredentialsConnectionFactoryAdapter && this.innerFactory instanceof ActiveMQConnectionFactory) {
            ((ActiveMQConnectionFactory)this.innerFactory).setTransportListener(listener);
        }
    }

    public Connection createConnection() throws JMSException {
        return this.innerAdapter.createConnection();
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        return this.innerAdapter.createConnection(userName, password);
    }
}

