/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core;

import javax.jms.ConnectionFactory;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQPooledConnectionFactory
extends PooledConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveMQPooledConnectionFactory.class);

    public ActiveMQPooledConnectionFactory initDefault(ConnectionFactory connectionFactory) {
        try {
            this.setConnectionFactory(connectionFactory);
            this.setCreateConnectionOnStartup(true);
            this.setIdleTimeout(0);
            this.setMaxConnections(3);
            this.setMaximumActiveSessionPerConnection(100);
            this.setTimeBetweenExpirationCheckMillis(30000L);
            this.setBlockIfSessionPoolIsFull(false);
            this.start();
        }
        catch (Exception e) {
            LOGGER.error("Failed to setup the message queues", (Throwable)e);
        }
        return this;
    }
}

