/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core.spring;

import de.taimos.dvalin.interconnect.core.daemon.ADaemonProxyFactory;
import de.taimos.dvalin.interconnect.core.daemon.IDaemonProxyFactory;
import de.taimos.dvalin.interconnect.core.daemon.IDaemonRequestResponse;
import de.taimos.dvalin.interconnect.core.spring.DaemonMessageSenderHeader;
import de.taimos.dvalin.interconnect.core.spring.IDaemonMessageSender;
import de.taimos.dvalin.interconnect.model.InterconnectObject;
import de.taimos.dvalin.interconnect.model.service.IDaemon;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DaemonProxyFactory
implements IDaemonProxyFactory {
    @Autowired
    private IDaemonRequestResponse requestResponse;
    @Autowired
    private IDaemonMessageSender messageSender;
    private DaemonProxyFactoryImpl impl;

    @PostConstruct
    public void start() {
        this.impl = new DaemonProxyFactoryImpl(this.requestResponse, this.messageSender);
    }

    @Override
    public <D extends IDaemon> D create(Class<D> daemon) {
        return this.impl.create(daemon);
    }

    private static final class DaemonProxyFactoryImpl
    extends ADaemonProxyFactory {
        private final IDaemonRequestResponse requestResponse;
        private final IDaemonMessageSender messageSender;

        public DaemonProxyFactoryImpl(IDaemonRequestResponse aRequestResponse, IDaemonMessageSender aMessageSender) {
            this.requestResponse = aRequestResponse;
            this.messageSender = aMessageSender;
        }

        @Override
        protected void sendToQueue(UUID uuid, String queue, InterconnectObject ico, boolean secure) throws Exception {
            this.messageSender.sendToQueue(queue, ico, secure, DaemonMessageSenderHeader.createRequestUUID(uuid));
        }

        @Override
        protected <R> R syncRequest(UUID uuid, String queue, InterconnectObject request, Class<R> responseClazz, long timeout, TimeUnit unit, boolean secure) throws ExecutionException {
            return this.requestResponse.sync(uuid, queue, request, responseClazz, timeout, unit, secure);
        }
    }
}

