/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core.spring;

import com.google.common.base.Preconditions;
import de.taimos.dvalin.interconnect.model.InterconnectObject;
import java.util.UUID;

public final class DaemonMessageSenderHeader {
    private final Field field;
    private final Object value;

    private DaemonMessageSenderHeader(Field field, Object value) {
        this.field = field;
        this.value = value;
    }

    public static DaemonMessageSenderHeader createRequestUUID(UUID requestUUID) {
        Preconditions.checkNotNull((Object)requestUUID, (Object)"Universally unique identifier of the request");
        return new DaemonMessageSenderHeader(Field.RequestUUID, requestUUID.toString());
    }

    public static DaemonMessageSenderHeader createICOClass(Class<? extends InterconnectObject> ico) {
        Preconditions.checkNotNull(ico, (Object)"Interconnect Object");
        return new DaemonMessageSenderHeader(Field.icoClass, ico.getName());
    }

    public Field getField() {
        return this.field;
    }

    public Object getValue() {
        return this.value;
    }

    public static enum Field {
        RequestUUID("InterconnectRequestUUID"),
        icoClass("InterconnectICOClass");

        private final String name;

        private Field() {
            this.name = this.name();
        }

        private Field(String aName) {
            this.name = aName;
        }

        public String getName() {
            return this.name;
        }
    }
}

