/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core.spring;

import de.taimos.daemon.spring.annotations.ProdComponent;
import de.taimos.dvalin.interconnect.core.daemon.ADaemonMessageHandler;
import de.taimos.dvalin.interconnect.core.daemon.DaemonResponse;
import de.taimos.dvalin.interconnect.core.daemon.IdemponentRetryException;
import de.taimos.dvalin.interconnect.core.spring.IDaemonMessageSender;
import de.taimos.dvalin.interconnect.model.service.ADaemonHandler;
import de.taimos.dvalin.interconnect.model.service.IDaemonHandler;
import javax.annotation.PostConstruct;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ErrorHandler;

@ProdComponent(value="messageListener")
public final class DaemonMessageListener
implements MessageListener,
ErrorHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDaemonMessageSender messageSender;
    @Autowired
    private BeanFactory beanFactory;
    private DaemonMessageHandler handler;

    @PostConstruct
    public void start() {
        ADaemonHandler rh = (ADaemonHandler)this.beanFactory.getBean("requestHandler");
        this.handler = new DaemonMessageHandler(this.logger, rh.getClass(), this.messageSender, this.beanFactory);
    }

    public void onMessage(Message message) {
        try {
            this.handler.onMessage(message);
        }
        catch (IdemponentRetryException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Exception", (Throwable)e);
        }
    }

    public void handleError(Throwable e) {
        this.logger.warn("Exception, retry!", e);
    }

    private static final class DaemonMessageHandler
    extends ADaemonMessageHandler {
        private final Logger logger;
        private final IDaemonMessageSender messageSender;
        private final BeanFactory beanFactory;

        public DaemonMessageHandler(Logger aLogger, Class<? extends ADaemonHandler> aHandlerClazz, IDaemonMessageSender aMessageSender, BeanFactory beanFactory) {
            super(aHandlerClazz, false);
            this.logger = aLogger;
            this.messageSender = aMessageSender;
            this.beanFactory = beanFactory;
        }

        @Override
        protected void reply(DaemonResponse response, boolean secure) throws Exception {
            this.messageSender.reply(response, secure);
        }

        @Override
        protected IDaemonHandler createRequestHandler() {
            return (ADaemonHandler)this.beanFactory.getBean("requestHandler");
        }

        @Override
        protected Logger getLogger() {
            return this.logger;
        }
    }
}

