/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core.daemon;

import de.taimos.dvalin.interconnect.core.daemon.IDaemonProxyFactory;
import de.taimos.dvalin.interconnect.model.ivo.IPageable;
import de.taimos.dvalin.interconnect.model.ivo.IPageableBuilder;
import de.taimos.dvalin.interconnect.model.ivo.IVO;
import de.taimos.dvalin.interconnect.model.ivo.util.IVOQueryResultIVO_v1;
import de.taimos.dvalin.interconnect.model.service.IDaemon;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;

public final class PagingController<E extends IVO>
implements Iterator<E> {
    private static final Method NO_SUCH_METHOD;
    private static final ConcurrentHashMap<String, Method> METHOD_CACHE;
    private final IDaemonProxyFactory proxyFactory;
    private final Class<? extends IDaemon> daemonClass;
    private final int limit;
    private final IPageable initialRequest;
    private int nextOffset = 0;
    private int batchIndex = -1;
    private List<E> batch;

    public PagingController(IDaemonProxyFactory proxyFactory, Class<? extends IDaemon> daemonClass, int limit, IPageable initialRequest) {
        this.proxyFactory = proxyFactory;
        this.daemonClass = daemonClass;
        this.limit = limit;
        this.initialRequest = initialRequest;
    }

    public PagingController(IDaemonProxyFactory proxyFactory, Class<? extends IDaemon> daemonClass, IPageable initialRequest) {
        this(proxyFactory, daemonClass, 100, initialRequest);
    }

    private Method scanProxyMethods(Object proxy) {
        for (Method method : proxy.getClass().getDeclaredMethods()) {
            if (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(this.initialRequest.getClass())) continue;
            return method;
        }
        return null;
    }

    private Method extractProxyMethod(IDaemon proxy) {
        String cachekey = proxy.getClass().getCanonicalName() + ":" + this.initialRequest.getClass().getCanonicalName();
        Method cached = METHOD_CACHE.get(cachekey);
        if (cached != null) {
            if (cached.equals(NO_SUCH_METHOD)) {
                throw new RuntimeException("proxy method not found for " + this.initialRequest.getClass());
            }
            return cached;
        }
        Method method = this.scanProxyMethods(proxy);
        if (method == null) {
            METHOD_CACHE.putIfAbsent(cachekey, NO_SUCH_METHOD);
            throw new RuntimeException("proxy method not found for " + this.initialRequest.getClass());
        }
        method.setAccessible(true);
        METHOD_CACHE.putIfAbsent(cachekey, method);
        return method;
    }

    @Override
    public boolean hasNext() {
        if (this.batch != null && this.batch.size() == 0) {
            return false;
        }
        int nextBatchIndex = this.batchIndex + 1;
        if (this.batch == null || nextBatchIndex == this.batch.size()) {
            IVOQueryResultIVO_v1 list;
            IVO request;
            if (this.batch != null && this.batch.size() != this.limit) {
                return false;
            }
            try {
                IPageableBuilder b = this.initialRequest.createPageableBuilder();
                b.withOffset(Integer.valueOf(this.nextOffset));
                b.withLimit(Integer.valueOf(this.limit));
                request = b.build();
            }
            catch (Exception e) {
                throw new RuntimeException("Can not build from IVO", e);
            }
            try {
                IDaemon proxy = this.proxyFactory.create(this.daemonClass);
                Method proxyMethod = this.extractProxyMethod(proxy);
                list = (IVOQueryResultIVO_v1)proxyMethod.invoke((Object)proxy, request);
            }
            catch (Exception e) {
                throw new RuntimeException("Can not get next elements", e);
            }
            this.nextOffset += this.limit;
            this.batchIndex = -1;
            this.batch = list.getElements();
            return this.batch.size() != 0;
        }
        return true;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.batchIndex;
        return (E)((IVO)this.batch.get(this.batchIndex));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static {
        try {
            NO_SUCH_METHOD = String.class.getMethod("toString", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        METHOD_CACHE = new ConcurrentHashMap();
    }
}

