/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core.daemon;

import de.taimos.dvalin.interconnect.core.daemon.IDaemonProxyFactory;
import de.taimos.dvalin.interconnect.model.InterconnectContext;
import de.taimos.dvalin.interconnect.model.InterconnectObject;
import de.taimos.dvalin.interconnect.model.ivo.daemon.VoidIVO;
import de.taimos.dvalin.interconnect.model.service.Daemon;
import de.taimos.dvalin.interconnect.model.service.DaemonError;
import de.taimos.dvalin.interconnect.model.service.DaemonScanner;
import de.taimos.dvalin.interconnect.model.service.IDaemon;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public abstract class ADaemonProxyFactory
implements IDaemonProxyFactory {
    protected abstract void sendToQueue(UUID var1, String var2, InterconnectObject var3, boolean var4) throws Exception;

    protected abstract <R> R syncRequest(UUID var1, String var2, InterconnectObject var3, Class<R> var4, long var5, TimeUnit var7, boolean var8) throws ExecutionException;

    @Override
    public final <D extends IDaemon> D create(Class<D> daemon) {
        if (!daemon.isAnnotationPresent(Daemon.class)) {
            throw new IllegalArgumentException("Daemon interface has no @Daemon annotation");
        }
        final String queueName = daemon.getAnnotation(Daemon.class).name() + ".request";
        return (D)((IDaemon)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{daemon}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    DaemonScanner.DaemonMethod dm = DaemonScanner.scan((Method)method);
                    if (dm.getType() == DaemonScanner.Type.voit) {
                        ADaemonProxyFactory.this.sendToQueue(InterconnectContext.getUuid(), queueName, (InterconnectObject)args[0], dm.isSecure());
                        return null;
                    }
                    Class responseClass = method.getReturnType().equals(Void.TYPE) ? VoidIVO.class : method.getReturnType();
                    return ADaemonProxyFactory.this.syncRequest(InterconnectContext.getUuid(), queueName, (InterconnectObject)args[0], responseClass, dm.getTimeoutInMs(), TimeUnit.MILLISECONDS, dm.isSecure());
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof DaemonError) {
                        throw e.getCause();
                    }
                    if (e.getCause() != null) {
                        throw e.getCause();
                    }
                    throw e;
                }
            }
        }));
    }
}

