/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.dynamodb;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTable;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import de.taimos.dvalin.cloud.aws.AWSClient;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public abstract class AbstractDynamoDAO<T> {
    public final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @AWSClient
    protected AmazonDynamoDBClient client;
    protected DynamoDBMapper mapper;
    @Value(value="${dynamodb.url:}")
    private String dynamodbUrl;

    @PostConstruct
    public final void init() {
        if (!this.dynamodbUrl.isEmpty()) {
            this.client.setEndpoint(this.dynamodbUrl);
        }
        this.mapper = new DynamoDBMapper((AmazonDynamoDB)this.client);
        try {
            DescribeTableResult tableResult = this.client.describeTable(this.getTableName());
            this.LOGGER.info("DynamoDB table exists: {}", (Object)tableResult.getTable());
        }
        catch (ResourceNotFoundException e) {
            CreateTableRequest request = this.mapper.generateCreateTableRequest(this.getEntityClass());
            this.LOGGER.info("Create DynamoDB table: {}", (Object)request);
            request.setProvisionedThroughput(this.getProvisionedThroughput());
            this.modifyCreateTableRequest(request);
            CreateTableResult table = this.client.createTable(request);
            this.LOGGER.info("Created table: {}", (Object)table.getTableDescription());
        }
    }

    protected void modifyCreateTableRequest(CreateTableRequest request) {
    }

    protected ProvisionedThroughput getProvisionedThroughput() {
        return new ProvisionedThroughput(Long.valueOf(1L), Long.valueOf(1L));
    }

    protected abstract Class<T> getEntityClass();

    protected String getTableName() {
        Class<T> entityClass = this.getEntityClass();
        if (!entityClass.isAnnotationPresent(DynamoDBTable.class)) {
            throw new IllegalStateException("Used getTableName on entity without @DynamoDBTable annotation");
        }
        return entityClass.getAnnotation(DynamoDBTable.class).tableName();
    }
}

