package de.taimos.dvalin.daemon.conditional;

/*
 * #%L
 * Daemon support for dvalin
 * %%
 * Copyright (C) 2015 - 2016 Taimos GmbH
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import java.util.Map;

import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class BeanAvailableCondition implements Condition {

    @Override
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Map<String, Object> attributes = metadata.getAnnotationAttributes(BeanAvailable.class.getCanonicalName());
        if (attributes != null ) {
            Object value = attributes.get("value");
            if (value != null && value instanceof Class) {
                String[] beans = BeanFactoryUtils.beanNamesForTypeIncludingAncestors(context.getBeanFactory(), (Class<?>) value);
                return beans.length > 0;
            }
        }
        return false;
    }

}
