/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.daemon;

import de.taimos.daemon.properties.IPropertyProvider;
import java.util.Map;
import java.util.stream.Collectors;

public class EnvPropertyProvider
implements IPropertyProvider {
    private static final String ENV_PREFIX = "DVALIN_";

    @Override
    public Map<String, String> loadProperties() {
        return System.getenv().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(ENV_PREFIX)).collect(Collectors.toMap(e -> this.generateKey((String)e.getKey()), Map.Entry::getValue));
    }

    private String generateKey(String key) {
        return key.substring(ENV_PREFIX.length()).replace("_", ".").toLowerCase();
    }

    public static boolean isConfigured() {
        return System.getenv().keySet().stream().anyMatch(s -> s.startsWith(ENV_PREFIX));
    }
}

