/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.daemon.log;

import de.taimos.daemon.ILoggingConfigurer;
import de.taimos.daemon.log4j.JSONLayout;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class StructuredLogConfigurer
implements ILoggingConfigurer {
    private final Logger rlog = Logger.getRootLogger();
    private ConsoleAppender console;

    public void initializeLogging() throws Exception {
        this.rlog.removeAllAppenders();
        this.rlog.setLevel(Level.INFO);
        this.console = new ConsoleAppender();
        this.console.setName("CONSOLE");
        this.console.setLayout((Layout)new JSONLayout());
        this.console.setTarget("System.out");
        this.console.activateOptions();
        this.rlog.addAppender((Appender)this.console);
    }

    public void reconfigureLogging() throws Exception {
        this.rlog.setLevel(Level.toLevel((String)System.getProperty("logger.level"), (Level)Level.INFO));
    }

    public void simpleLogging() throws Exception {
        this.initializeLogging();
        this.reconfigureLogging();
    }

    public static void setup() {
        System.setProperty("loggerConfigurer", StructuredLogConfigurer.class.getCanonicalName());
    }
}

