/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.cluster.hazelcast;

import com.hazelcast.config.SerializerConfig;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.util.Optional;

public class OptionalSerializer
implements StreamSerializer<Optional> {
    public void write(ObjectDataOutput out, Optional object) throws IOException {
        if (object.isPresent()) {
            out.writeObject(object.get());
        } else {
            out.writeObject(null);
        }
    }

    public Optional read(ObjectDataInput in) throws IOException {
        Object result = in.readObject();
        return result == null ? Optional.empty() : Optional.of(result);
    }

    public int getTypeId() {
        return 1;
    }

    public void destroy() {
    }

    public static SerializerConfig createConfig() {
        SerializerConfig optionalSerializer = new SerializerConfig();
        optionalSerializer.setClass(OptionalSerializer.class);
        optionalSerializer.setTypeClass(Optional.class);
        return optionalSerializer;
    }
}

