/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.cluster.hazelcast;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.spring.cache.HazelcastCacheManager;
import de.taimos.daemon.spring.conditional.BeanAvailable;
import de.taimos.daemon.spring.conditional.OnSystemProperty;
import de.taimos.dvalin.cluster.hazelcast.ClusterInfoProvider;
import de.taimos.dvalin.cluster.hazelcast.DynamicMemberConfig;
import de.taimos.dvalin.cluster.hazelcast.OptionalSerializer;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HazelcastConfig {
    private static final String HAZELCAST_PUBLIC_IP = "HAZELCAST_PUBLIC_IP";
    @Autowired(required=false)
    private List<LifecycleListener> lifecycleListeners;

    @Bean
    @BeanAvailable(value=ClusterInfoProvider.class)
    @OnSystemProperty(propertyName="hazelcast.client")
    public HazelcastInstance createClient(ClusterInfoProvider infoProvider, @Value(value="${hazelcast.client}") String clusterName) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setAddresses(infoProvider.getClusterMemberAddresses(clusterName));
        clientConfig.getSerializationConfig().addSerializerConfig(OptionalSerializer.createConfig());
        HazelcastInstance client = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        if (this.lifecycleListeners != null) {
            this.lifecycleListeners.forEach(arg_0 -> ((LifecycleService)client.getLifecycleService()).addLifecycleListener(arg_0));
        }
        return client;
    }

    @Bean
    @BeanAvailable(value=ClusterInfoProvider.class)
    @OnSystemProperty(propertyName="hazelcast.cluster", propertyValue="true")
    public HazelcastInstance createCluster(ClusterInfoProvider infoProvider) {
        Config cfg = new Config();
        cfg.setProperty("hazelcast.max.join.seconds", "15");
        cfg.setProperty("hazelcast.max.no.heartbeat.seconds", "15");
        cfg.setProperty("hazelcast.member.list.publish.interval.seconds", "60");
        NetworkConfig networkConfig = cfg.getNetworkConfig();
        String hazelcastPublicIp = System.getenv(HAZELCAST_PUBLIC_IP);
        if (hazelcastPublicIp != null) {
            networkConfig.setPublicAddress(hazelcastPublicIp);
        }
        networkConfig.setPortAutoIncrement(false);
        JoinConfig joinConfig = networkConfig.getJoin();
        joinConfig.getMulticastConfig().setEnabled(false);
        joinConfig.getAwsConfig().setEnabled(false);
        joinConfig.setTcpIpConfig((TcpIpConfig)new DynamicMemberConfig(infoProvider));
        cfg.getSerializationConfig().addSerializerConfig(OptionalSerializer.createConfig());
        HazelcastInstance instance = Hazelcast.newHazelcastInstance((Config)cfg);
        if (this.lifecycleListeners != null) {
            this.lifecycleListeners.forEach(arg_0 -> ((LifecycleService)instance.getLifecycleService()).addLifecycleListener(arg_0));
        }
        return instance;
    }

    @Bean
    @BeanAvailable(value=HazelcastInstance.class)
    CacheManager cacheManager(HazelcastInstance hazelcastInstance) {
        return new HazelcastCacheManager(hazelcastInstance);
    }
}

