/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.cloud.aws;

import com.amazonaws.services.autoscaling.AmazonAutoScalingClient;
import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.AutoScalingInstanceDetails;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsResult;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesResult;
import com.amazonaws.services.autoscaling.model.Instance;
import com.amazonaws.services.autoscaling.model.TagDescription;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.util.EC2MetadataUtils;
import com.google.common.base.Preconditions;
import de.taimos.dvalin.cloud.aws.AWSClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class EC2Context {
    @AWSClient
    private AmazonEC2Client ec2Client;
    @AWSClient
    private AmazonAutoScalingClient autoScalingClient;

    public String getInstanceId() {
        return EC2MetadataUtils.getInstanceId();
    }

    public Map<String, String> getInstanceTags() {
        HashMap<String, String> map = new HashMap<String, String>();
        com.amazonaws.services.ec2.model.Instance instance = this.getInstance();
        for (Tag tag : instance.getTags()) {
            map.put(tag.getKey(), tag.getValue());
        }
        return map;
    }

    public String getAutoScalingGroup() {
        DescribeAutoScalingInstancesRequest req = new DescribeAutoScalingInstancesRequest();
        req.setInstanceIds(Collections.singleton(this.getInstanceId()));
        DescribeAutoScalingInstancesResult result = this.autoScalingClient.describeAutoScalingInstances(req);
        if (result.getAutoScalingInstances().size() != 1) {
            throw new IllegalStateException("Found multiple auto scaling instances");
        }
        return ((AutoScalingInstanceDetails)result.getAutoScalingInstances().get(0)).getAutoScalingGroupName();
    }

    public List<String> getAutoScalingMembers(String autoScalingGroupName) {
        Preconditions.checkArgument((autoScalingGroupName != null && !autoScalingGroupName.isEmpty() ? 1 : 0) != 0);
        AutoScalingGroup autoScalingGroup = this.getAutoScalingGroup(autoScalingGroupName);
        ArrayList<String> list = new ArrayList<String>();
        for (Instance instance : autoScalingGroup.getInstances()) {
            if (!instance.getHealthStatus().equals("Healthy")) continue;
            list.add(instance.getInstanceId());
        }
        return list;
    }

    public List<String> getPrivateAutoScalingMemberIPs(String autoScalingGroupName) {
        Preconditions.checkArgument((autoScalingGroupName != null && !autoScalingGroupName.isEmpty() ? 1 : 0) != 0);
        List<String> members = this.getAutoScalingMembers(autoScalingGroupName);
        DescribeInstancesRequest req = new DescribeInstancesRequest();
        req.setInstanceIds(members);
        DescribeInstancesResult result = this.ec2Client.describeInstances(req);
        ArrayList<String> list = new ArrayList<String>();
        for (Reservation reservation : result.getReservations()) {
            for (com.amazonaws.services.ec2.model.Instance instance : reservation.getInstances()) {
                if (!instance.getState().getName().equals("running")) continue;
                list.add(instance.getPrivateIpAddress());
            }
        }
        return list;
    }

    public AutoScalingGroup getAutoScalingGroup(String autoScalingGroupName) {
        Preconditions.checkArgument((autoScalingGroupName != null && !autoScalingGroupName.isEmpty() ? 1 : 0) != 0);
        DescribeAutoScalingGroupsRequest req = new DescribeAutoScalingGroupsRequest();
        req.setAutoScalingGroupNames(Collections.singleton(autoScalingGroupName));
        DescribeAutoScalingGroupsResult result = this.autoScalingClient.describeAutoScalingGroups(req);
        if (result.getAutoScalingGroups().size() != 1) {
            throw new IllegalStateException("Found multiple auto scaling groups");
        }
        return (AutoScalingGroup)result.getAutoScalingGroups().get(0);
    }

    public Map<String, String> getAutoScalingGroupTags(String autoScalingGroupName) {
        Preconditions.checkArgument((autoScalingGroupName != null && !autoScalingGroupName.isEmpty() ? 1 : 0) != 0);
        AutoScalingGroup group = this.getAutoScalingGroup(autoScalingGroupName);
        HashMap<String, String> tags = new HashMap<String, String>();
        for (TagDescription tagDescription : group.getTags()) {
            tags.put(tagDescription.getKey(), tagDescription.getValue());
        }
        return tags;
    }

    public com.amazonaws.services.ec2.model.Instance getInstance() {
        DescribeInstancesRequest req = new DescribeInstancesRequest();
        req.setInstanceIds(Collections.singleton(this.getInstanceId()));
        DescribeInstancesResult result = this.ec2Client.describeInstances(req);
        if (result.getReservations().size() != 1) {
            throw new IllegalStateException("Found multiple instances");
        }
        List instances = ((Reservation)result.getReservations().get(0)).getInstances();
        if (instances.size() != 1) {
            throw new IllegalStateException("Found multiple instances");
        }
        return (com.amazonaws.services.ec2.model.Instance)instances.get(0);
    }
}

