/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.cloud.aws;

import com.amazonaws.AmazonWebServiceClient;
import de.taimos.dvalin.cloud.aws.AWSClient;
import de.taimos.dvalin.cloud.aws.AWSClientFactory;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringValueResolver;

@Component
public class AWSClientBeanPostProcessor
implements InstantiationAwareBeanPostProcessor,
EmbeddedValueResolverAware,
Serializable {
    private StringValueResolver resolver;

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.resolver = resolver;
    }

    public Object postProcessBeforeInstantiation(Class<?> beanClass, String beanName) {
        return null;
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) {
        return true;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) {
        InjectionMetadata metadata = this.buildResourceMetadata(bean.getClass());
        try {
            metadata.inject(bean, beanName, pvs);
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Injection of resource dependencies failed", ex);
        }
        return pvs;
    }

    private InjectionMetadata buildResourceMetadata(Class<?> clazz) {
        LinkedList<InjectionMetadata.InjectedElement> elements = new LinkedList<InjectionMetadata.InjectedElement>();
        Class<?> targetClass = clazz;
        do {
            LinkedList<InjectionMetadata.InjectedElement> currElements = new LinkedList<InjectionMetadata.InjectedElement>();
            for (Field field : targetClass.getDeclaredFields()) {
                this.doScanField(currElements, field);
            }
            for (AccessibleObject accessibleObject : targetClass.getDeclaredMethods()) {
                this.doScanMethod(clazz, currElements, (Method)accessibleObject);
            }
            elements.addAll(0, currElements);
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        return new InjectionMetadata(clazz, elements);
    }

    private void doScanField(LinkedList<InjectionMetadata.InjectedElement> currElements, Field field) {
        if (field.isAnnotationPresent(AWSClient.class)) {
            if (Modifier.isStatic(field.getModifiers())) {
                throw new IllegalStateException("@AWSClient annotation is not supported on static fields");
            }
            currElements.add(new AWSClientElement(field, null, field.getAnnotation(AWSClient.class)));
        }
    }

    private void doScanMethod(Class<?> clazz, LinkedList<InjectionMetadata.InjectedElement> currElements, Method method) {
        Method bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)method);
        if (!BridgeMethodResolver.isVisibilityBridgeMethodPair((Method)method, (Method)bridgedMethod)) {
            return;
        }
        if (method.equals(ClassUtils.getMostSpecificMethod((Method)method, clazz)) && bridgedMethod.isAnnotationPresent(AWSClient.class)) {
            if (Modifier.isStatic(method.getModifiers())) {
                throw new IllegalStateException("@AWSClient annotation is not supported on static methods");
            }
            if (method.getParameterTypes().length != 1) {
                throw new IllegalStateException("@AWSClient annotation requires a single-arg method: " + method);
            }
            PropertyDescriptor pd = BeanUtils.findPropertyForMethod((Method)bridgedMethod, clazz);
            currElements.add(new AWSClientElement(method, pd, method.getAnnotation(AWSClient.class)));
        }
    }

    private class AWSClientElement
    extends InjectionMetadata.InjectedElement {
        private final Logger LOGGER;
        private final AWSClient client;

        public AWSClientElement(Member member, PropertyDescriptor pd, AWSClient client) {
            super(member, pd);
            this.LOGGER = LoggerFactory.getLogger(AWSClientElement.class);
            this.client = client;
        }

        private DependencyDescriptor getDependencyDescriptor() {
            if (this.isField) {
                return new DependencyDescriptor((Field)this.member, true);
            }
            return new DependencyDescriptor(new MethodParameter((Method)this.member, 0), true);
        }

        protected Object getResourceToInject(Object target, String requestingBeanName) {
            Class dependencyType = this.getDependencyDescriptor().getDependencyType();
            if (!AmazonWebServiceClient.class.isAssignableFrom(dependencyType)) {
                throw new RuntimeException("Field has to be of type AmazonWebServiceClient but was of type " + dependencyType.getCanonicalName());
            }
            AWSClientFactory factory = new AWSClientFactory();
            factory.withRegion(this.getRegionName(this.client));
            factory.withEndpoint(this.getCustomEndpoint(this.client));
            return factory.create(dependencyType);
        }

        private String getCustomEndpoint(AWSClient client) {
            if (!client.endpoint().isEmpty()) {
                try {
                    String endpointString = AWSClientBeanPostProcessor.this.resolver.resolveStringValue(this.client.endpoint());
                    if (!endpointString.isEmpty()) {
                        return endpointString;
                    }
                }
                catch (IllegalArgumentException e) {
                    this.LOGGER.warn("Failed to read endpoint property", (Throwable)e);
                }
            }
            return null;
        }

        private String getRegionName(AWSClient client) {
            String regionString;
            if (!client.region().isEmpty()) {
                try {
                    regionString = AWSClientBeanPostProcessor.this.resolver.resolveStringValue(this.client.region());
                    if (!regionString.isEmpty()) {
                        return regionString;
                    }
                }
                catch (IllegalArgumentException e) {
                    this.LOGGER.warn("Failed to read regionProperty", (Throwable)e);
                }
            }
            try {
                regionString = AWSClientBeanPostProcessor.this.resolver.resolveStringValue("${aws.region}");
                if (!regionString.isEmpty()) {
                    return regionString;
                }
            }
            catch (IllegalArgumentException e) {
                this.LOGGER.debug("Did not find aws.region system property");
            }
            return null;
        }
    }
}

