/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.cloud.aws;

import com.amazonaws.services.cloudformation.AmazonCloudFormationClient;
import com.amazonaws.services.cloudformation.model.ResourceSignalStatus;
import com.amazonaws.services.cloudformation.model.SignalResourceRequest;
import com.google.common.base.Preconditions;
import de.taimos.dvalin.cloud.aws.AWSClient;
import de.taimos.dvalin.cloud.aws.EC2Context;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CloudFormation {
    public static final String TAG_CLOUDFORMATION_LOGICAL_ID = "aws:cloudformation:logical-id";
    public static final String TAG_CLOUDFORMATION_STACK_NAME = "aws:cloudformation:stack-name";
    @AWSClient
    private AmazonCloudFormationClient cloudFormationClient;
    @Autowired
    private EC2Context ec2Context;

    public void signalReady(String stackName, String resourceName) {
        Preconditions.checkArgument((stackName != null && !stackName.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((resourceName != null && !resourceName.isEmpty() ? 1 : 0) != 0);
        SignalResourceRequest req = new SignalResourceRequest();
        req.setLogicalResourceId(resourceName);
        req.setStackName(stackName);
        req.setStatus(ResourceSignalStatus.SUCCESS);
        req.setUniqueId(this.ec2Context.getInstanceId());
        this.cloudFormationClient.signalResource(req);
    }

    public void signalReady(String resourceName) {
        Preconditions.checkArgument((resourceName != null && !resourceName.isEmpty() ? 1 : 0) != 0);
        Map<String, String> hostTags = this.ec2Context.getInstanceTags();
        this.signalReady(hostTags.get(TAG_CLOUDFORMATION_STACK_NAME), resourceName);
    }

    public void signalReady() {
        Map<String, String> hostTags = this.ec2Context.getInstanceTags();
        this.signalReady(hostTags.get(TAG_CLOUDFORMATION_STACK_NAME), hostTags.get(TAG_CLOUDFORMATION_LOGICAL_ID));
    }
}

