/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.cloud.aws;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import de.taimos.dvalin.cloud.aws.AWSClient;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringValueResolver;

@Component
public class AWSClientBeanPostProcessor
implements InstantiationAwareBeanPostProcessor,
EmbeddedValueResolverAware,
BeanFactoryAware,
Serializable {
    private transient ConfigurableListableBeanFactory beanFactory;
    private StringValueResolver resolver;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.resolver = resolver;
    }

    public Object postProcessBeforeInstantiation(Class<?> beanClass, String beanName) throws BeansException {
        return null;
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        return true;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        InjectionMetadata metadata = this.buildResourceMetadata(bean.getClass());
        try {
            metadata.inject(bean, beanName, pvs);
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Injection of resource dependencies failed", ex);
        }
        return pvs;
    }

    private InjectionMetadata buildResourceMetadata(Class<?> clazz) {
        LinkedList elements = new LinkedList();
        Class<?> targetClass = clazz;
        do {
            LinkedList<AWSClientElement> currElements = new LinkedList<AWSClientElement>();
            for (Field field : targetClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(AWSClient.class)) continue;
                if (Modifier.isStatic(field.getModifiers())) {
                    throw new IllegalStateException("@AWSClient annotation is not supported on static fields");
                }
                currElements.add(new AWSClientElement(field, null, field.getAnnotation(AWSClient.class)));
            }
            for (AccessibleObject accessibleObject : targetClass.getDeclaredMethods()) {
                Method bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)accessibleObject);
                if (!BridgeMethodResolver.isVisibilityBridgeMethodPair((Method)accessibleObject, (Method)bridgedMethod) || !((Method)accessibleObject).equals(ClassUtils.getMostSpecificMethod((Method)accessibleObject, clazz)) || !bridgedMethod.isAnnotationPresent(AWSClient.class)) continue;
                if (Modifier.isStatic(((Method)accessibleObject).getModifiers())) {
                    throw new IllegalStateException("@AWSClient annotation is not supported on static methods");
                }
                if (((Method)accessibleObject).getParameterTypes().length != 1) {
                    throw new IllegalStateException("@AWSClient annotation requires a single-arg method: " + accessibleObject);
                }
                PropertyDescriptor pd = BeanUtils.findPropertyForMethod((Method)bridgedMethod, clazz);
                currElements.add(new AWSClientElement((Member)((Object)accessibleObject), pd, ((Method)accessibleObject).getAnnotation(AWSClient.class)));
            }
            elements.addAll(0, currElements);
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        return new InjectionMetadata(clazz, elements);
    }

    private class AWSClientElement
    extends InjectionMetadata.InjectedElement {
        private final Logger LOGGER;
        private final AWSClient client;

        public AWSClientElement(Member member, PropertyDescriptor pd, AWSClient client) {
            super(member, pd);
            this.LOGGER = LoggerFactory.getLogger(AWSClientElement.class);
            this.client = client;
        }

        private DependencyDescriptor getDependencyDescriptor() {
            if (this.isField) {
                return new DependencyDescriptor((Field)this.member, true);
            }
            return new DependencyDescriptor(new MethodParameter((Method)this.member, 0), true);
        }

        protected Object getResourceToInject(Object target, String requestingBeanName) {
            Class dependencyType = this.getDependencyDescriptor().getDependencyType();
            if (!AmazonWebServiceClient.class.isAssignableFrom(dependencyType)) {
                throw new RuntimeException("Field has to be of type AmazonWebServiceClient but was of type " + dependencyType.getCanonicalName());
            }
            Region region = this.getRegion(this.client);
            this.LOGGER.info("Using AWS region {}", (Object)region.toString());
            AWSCredentials cred = this.getStaticCredentials();
            Object provider = cred != null ? new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new StaticCredentialsProvider(cred)}) : new DefaultAWSCredentialsProviderChain();
            AmazonWebServiceClient client = region.createClient(dependencyType, (AWSCredentialsProvider)provider, null);
            String endpoint = this.getCustomEndpoint(this.client);
            if (endpoint != null) {
                client.setEndpoint(endpoint);
            }
            return client;
        }

        private String getCustomEndpoint(AWSClient client) {
            if (!client.endpoint().isEmpty()) {
                try {
                    String endpointString = AWSClientBeanPostProcessor.this.resolver.resolveStringValue(this.client.endpoint());
                    if (!endpointString.isEmpty()) {
                        return endpointString;
                    }
                }
                catch (IllegalArgumentException e) {
                    this.LOGGER.warn("Failed to read endpoint property", (Throwable)e);
                }
            }
            return null;
        }

        private AWSCredentials getStaticCredentials() {
            try {
                String accessKey = AWSClientBeanPostProcessor.this.resolver.resolveStringValue("${aws.accessKeyId}");
                String secretKey = AWSClientBeanPostProcessor.this.resolver.resolveStringValue("${aws.secretKey}");
                if (!accessKey.isEmpty() && !secretKey.isEmpty()) {
                    return new BasicAWSCredentials(accessKey, secretKey);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return null;
        }

        private Region getRegion(AWSClient client) {
            String regionString;
            if (!client.region().isEmpty()) {
                try {
                    regionString = AWSClientBeanPostProcessor.this.resolver.resolveStringValue(this.client.region());
                    if (!regionString.isEmpty()) {
                        return Region.getRegion((Regions)Regions.fromName((String)regionString));
                    }
                }
                catch (IllegalArgumentException e) {
                    this.LOGGER.warn("Failed to read regionProperty", (Throwable)e);
                }
            }
            try {
                regionString = AWSClientBeanPostProcessor.this.resolver.resolveStringValue("${aws.region}");
                if (!regionString.isEmpty()) {
                    return Region.getRegion((Regions)Regions.fromName((String)regionString));
                }
            }
            catch (IllegalArgumentException e) {
                this.LOGGER.info("Did not find aws.region system property");
            }
            if (System.getenv("AWS_DEFAULT_REGION") != null) {
                return Region.getRegion((Regions)Regions.fromName((String)System.getenv("AWS_DEFAULT_REGION")));
            }
            if (System.getenv("AWS_REGION") != null) {
                return Region.getRegion((Regions)Regions.fromName((String)System.getenv("AWS_REGION")));
            }
            Region currentRegion = Regions.getCurrentRegion();
            if (currentRegion != null) {
                return currentRegion;
            }
            return Region.getRegion((Regions)Regions.DEFAULT_REGION);
        }
    }
}

