/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.daemon;

import de.taimos.daemon.DaemonStarter;
import de.taimos.httputils.WS;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class LogglyAppender
extends AppenderSkeleton {
    private static final String BASE_URL = "https://logs-01.loggly.com/inputs/";
    private String url;
    private LinkedBlockingQueue<String> eventQueue = new LinkedBlockingQueue();
    private Executor executor = Executors.newSingleThreadExecutor();

    public LogglyAppender(String token, String tags) {
        String _url = BASE_URL + token;
        if (tags != null && !tags.isEmpty()) {
            _url = _url + "/tag/" + tags;
        }
        this.url = _url + "/";
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                while (!LogglyAppender.this.closed) {
                    try {
                        HttpResponse post;
                        String json = (String)LogglyAppender.this.eventQueue.poll(5L, TimeUnit.SECONDS);
                        if (json == null || (post = WS.url((String)LogglyAppender.this.url).timeout(10000).contentType("application/json").body(json).post()).getStatusLine().getStatusCode() == 200) continue;
                        System.err.println("Failed to log to loggly");
                    }
                    catch (Exception e) {
                        System.err.println("Failed to log to loggly");
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void close() {
        this.closed = true;
    }

    public boolean requiresLayout() {
        return false;
    }

    protected void append(LoggingEvent event) {
        try {
            this.eventQueue.put(this.createJSON(event));
        }
        catch (InterruptedException e) {
            System.err.println("Failed to append event");
        }
    }

    private String createJSON(LoggingEvent event) {
        HashMap<String, Object> log = new HashMap<String, Object>();
        log.put("daemon", DaemonStarter.getDaemonName());
        log.put("instance", DaemonStarter.getInstanceId());
        log.put("host", DaemonStarter.getHostname());
        log.put("phase", DaemonStarter.getCurrentPhase().name());
        log.put("timestamp", new Date(event.getTimeStamp()).toString());
        log.put("level", event.getLevel().toString());
        log.put("source", event.getLoggerName());
        log.put("message", event.getRenderedMessage());
        if (event.getThrowableInformation() != null) {
            String[] throwableStrRep = event.getThrowableInformation().getThrowableStrRep();
            log.put("stacktrace", throwableStrRep);
        }
        if (event.getProperties() != null) {
            log.put("mdc", event.getProperties());
        }
        StringBuilder sb = new StringBuilder();
        this.addObject(sb, log);
        return sb.toString();
    }

    private void addObject(StringBuilder sb, Map<String, Object> map) {
        sb.append("{");
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        boolean first = true;
        for (Map.Entry<String, Object> entry : entrySet) {
            if (first) {
                first = false;
            } else {
                this.addSeparator(sb);
            }
            this.addField(sb, entry.getKey(), entry.getValue());
        }
        sb.append("}");
    }

    private void addField(StringBuilder sb, String field, Object value) {
        sb.append("\"");
        sb.append(this.cleanString(field));
        sb.append("\":");
        this.addValue(sb, value);
    }

    private void addSeparator(StringBuilder sb) {
        sb.append(",");
    }

    private void addArray(StringBuilder sb, Object ... values) {
        sb.append("[");
        for (int i = 0; i < values.length; ++i) {
            this.addValue(sb, values[i]);
            if (i == values.length - 1) continue;
            this.addSeparator(sb);
        }
        sb.append("]");
    }

    private void addValue(StringBuilder sb, Object value) {
        if (value instanceof String) {
            sb.append("\"");
            sb.append(this.cleanString((String)value));
            sb.append("\"");
        } else if (value instanceof Map) {
            this.addObject(sb, (Map)value);
        } else if (value instanceof Object[]) {
            this.addArray(sb, (Object[])value);
        } else {
            throw new RuntimeException("Invalid value: " + value);
        }
    }

    private String cleanString(String value) {
        return value.replaceAll("\"", "");
    }
}

