/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.daemon;

import de.taimos.daemon.DaemonManager;
import de.taimos.daemon.IDaemonLifecycleListener;
import de.taimos.daemon.LifecyclePhase;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.net.SyslogAppender;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class DaemonStarter {
    private static final AtomicReference<String> daemonName = new AtomicReference();
    private static final String instanceId = UUID.randomUUID().toString();
    private static final Properties daemonProperties = new Properties();
    private static final AtomicReference<String> hostname = new AtomicReference();
    private static final DaemonManager daemon = new DaemonManager();
    private static final AtomicBoolean devMode = new AtomicBoolean();
    private static final Logger rlog = Logger.getRootLogger();
    private static SyslogAppender syslog;
    private static DailyRollingFileAppender darofi;
    private static final AtomicReference<IDaemonLifecycleListener> lifecycleListener;
    private static final AtomicReference<LifecyclePhase> currentPhase;

    public static boolean isDevelopmentMode() {
        return devMode.get();
    }

    public static LifecyclePhase getCurrentPhase() {
        return currentPhase.get();
    }

    public static String getHostname() {
        return hostname.get();
    }

    public static String getDaemonName() {
        return daemonName.get();
    }

    public static String getInstanceId() {
        return instanceId;
    }

    public static Properties getDaemonProperties() {
        return daemonProperties;
    }

    private static IDaemonLifecycleListener getLifecycleListener() {
        if (lifecycleListener == null) {
            throw new RuntimeException("No lifecycle listener found");
        }
        return lifecycleListener.get();
    }

    public static void startDaemon(final String _daemonName, final IDaemonLifecycleListener _lifecycleListener) {
        new Thread(){

            @Override
            public void run() {
                DaemonStarter.doStartDaemon(_daemonName, _lifecycleListener);
            }
        }.start();
    }

    private static void doStartDaemon(String _daemonName, IDaemonLifecycleListener _lifecycleListener) {
        boolean updated = currentPhase.compareAndSet(LifecyclePhase.STOPPED, LifecyclePhase.STARTING);
        if (!updated) {
            rlog.error((Object)"Service already running");
            return;
        }
        daemonName.set(_daemonName);
        System.setProperty("daemonName", _daemonName);
        lifecycleListener.set(_lifecycleListener);
        String devmode = System.getProperty("developmentMode", "false");
        devMode.set(devmode != null && devmode.equals("true"));
        DaemonStarter.configureLogging();
        DaemonStarter.determineHostname();
        DaemonStarter.logStartupInfo();
        DaemonStarter.handleSignals();
        DaemonStarter.initProperties();
        DaemonStarter.amendLogAppender();
        if (!DaemonStarter.getLifecycleListener().doStart()) {
            DaemonStarter.abortSystem();
        }
        DaemonStarter.notifyStarted();
        daemon.block();
        if (!DaemonStarter.getLifecycleListener().doStop()) {
            DaemonStarter.abortSystem();
        }
        DaemonStarter.notifyStopped();
        System.exit(0);
    }

    private static void notifyStopped() {
        rlog.info((Object)(daemonName + " stopped!"));
        currentPhase.set(LifecyclePhase.STOPPED);
        DaemonStarter.getLifecycleListener().stopped();
    }

    private static void notifyStarted() {
        rlog.info((Object)(daemonName + " started!"));
        currentPhase.set(LifecyclePhase.STARTED);
        DaemonStarter.getLifecycleListener().started();
    }

    private static void logStartupInfo() {
        if (DaemonStarter.isDevelopmentMode()) {
            rlog.info((Object)"Running in development mode");
        } else {
            rlog.info((Object)"Running in production mode");
        }
        rlog.info((Object)("Running with instance id: " + instanceId));
        rlog.info((Object)("Running on host: " + hostname));
    }

    private static void determineHostname() {
        try {
            String host = InetAddress.getLocalHost().getHostName();
            if (host != null && !host.isEmpty()) {
                hostname.set(host);
            } else {
                rlog.error((Object)"Hostname could not be determined --> Exiting");
                DaemonStarter.abortSystem();
            }
        }
        catch (UnknownHostException e) {
            rlog.error((Object)"Getting hostname failed", (Throwable)e);
            DaemonStarter.abortSystem(e);
        }
    }

    private static void initProperties() {
        try {
            Map<String, String> properties = DaemonStarter.getLifecycleListener().loadProperties();
            if (properties != null) {
                for (Map.Entry<String, String> e : properties.entrySet()) {
                    DaemonStarter.addProperty(e.getKey(), String.valueOf(e.getValue()));
                }
            }
        }
        catch (Exception e) {
            rlog.error((Object)"Getting config data failed", (Throwable)e);
            DaemonStarter.abortSystem(e);
        }
    }

    private static void addProperty(String key, String value) {
        rlog.info((Object)String.format("Setting property: '%s' with value '%s'", key, value));
        daemonProperties.setProperty(key, value);
        System.setProperty(key, value);
    }

    private static void configureLogging() {
        try {
            rlog.removeAllAppenders();
            rlog.setLevel(Level.INFO);
            if (!DaemonStarter.isDevelopmentMode()) {
                darofi = new DailyRollingFileAppender();
                darofi.setName("DAROFI");
                darofi.setLayout((Layout)new PatternLayout("%d{HH:mm:ss,SSS} %-5p %c %x - %m%n"));
                darofi.setFile("log/" + DaemonStarter.getDaemonName() + ".log");
                darofi.setDatePattern("'.'yyyy-MM-dd");
                darofi.setAppend(true);
                darofi.setThreshold((Priority)Level.INFO);
                darofi.activateOptions();
                rlog.addAppender((Appender)darofi);
                syslog = new SyslogAppender();
                syslog.setName("SYSLOG");
                syslog.setLayout((Layout)new PatternLayout(DaemonStarter.getDaemonName() + ": %-5p %c %x - %m%n"));
                syslog.setSyslogHost("localhost");
                syslog.setFacility("LOCAL0");
                syslog.setFacilityPrinting(false);
                syslog.setThreshold((Priority)Level.INFO);
                syslog.activateOptions();
                rlog.addAppender((Appender)syslog);
            } else {
                ConsoleAppender console = new ConsoleAppender();
                console.setName("CONSOLE");
                console.setLayout((Layout)new PatternLayout("%d{HH:mm:ss,SSS} %-5p %c %x - %m%n"));
                console.setTarget("System.out");
                console.activateOptions();
                rlog.addAppender((Appender)console);
            }
        }
        catch (Exception e) {
            System.err.println("Logger config failed with exception: " + e.getMessage());
            DaemonStarter.getLifecycleListener().exception(currentPhase.get(), e);
        }
    }

    private static void amendLogAppender() {
        Level logLevel = Level.toLevel((String)daemonProperties.getProperty("logger.level"), (Level)Level.INFO);
        rlog.setLevel(logLevel);
        rlog.info((Object)String.format("Changed the the log level to %s", logLevel));
        if (!DaemonStarter.isDevelopmentMode()) {
            String host = daemonProperties.getProperty("syslog.host", "localhost");
            String facility = daemonProperties.getProperty("syslog.facility", "LOCAL0");
            String logfile = daemonProperties.getProperty("logger.file", "true");
            Level syslogLevel = Level.toLevel((String)daemonProperties.getProperty("syslog.level"), (Level)Level.WARN);
            if (logfile != null && logfile.equals("false")) {
                rlog.removeAppender((Appender)darofi);
            } else {
                darofi.setThreshold((Priority)logLevel);
                darofi.activateOptions();
            }
            syslog.setSyslogHost(host);
            syslog.setFacility(facility);
            syslog.setThreshold((Priority)syslogLevel);
            syslog.activateOptions();
            rlog.info((Object)String.format("Changed the SYSLOG Appender to host %s and facility %s", host, facility));
        }
    }

    public static void stopService() {
        currentPhase.set(LifecyclePhase.STOPPING);
        DaemonStarter.getLifecycleListener().stopping();
        daemon.stop();
    }

    private static final void handleSignals() {
        if (!System.getProperty("os.name").contains("Win") && !DaemonStarter.isDevelopmentMode()) {
            Signal.handle(new Signal("HUP"), new SignalHandler(){

                @Override
                public void handle(Signal arg0) {
                }
            });
            Signal.handle(new Signal("TERM"), new SignalHandler(){

                @Override
                public void handle(Signal arg0) {
                    DaemonStarter.stopService();
                }
            });
            Signal.handle(new Signal("USR2"), new SignalHandler(){

                @Override
                public void handle(Signal arg0) {
                    DaemonStarter.getLifecycleListener().signalUSR2();
                }
            });
        }
    }

    private static void abortSystem() {
        DaemonStarter.abortSystem(null);
    }

    private static void abortSystem(Throwable error) {
        currentPhase.set(LifecyclePhase.ABORTING);
        if (error != null) {
            DaemonStarter.getLifecycleListener().exception(LifecyclePhase.ABORTING, error);
        }
        DaemonStarter.getLifecycleListener().aborting();
        rlog.fatal((Object)"Unrecoverable error encountered --> Exiting");
        System.exit(1);
    }

    static {
        lifecycleListener = new AtomicReference();
        currentPhase = new AtomicReference<LifecyclePhase>(LifecyclePhase.STOPPED);
    }
}

