/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.daemon.log4j;

import de.taimos.httputils.WS;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class LogglyAppender
extends AppenderSkeleton {
    private static final String BASE_URL = "https://logs-01.loggly.com/inputs/";
    private String token;
    private String tags;
    private String url;
    private LinkedBlockingQueue<String> eventQueue = new LinkedBlockingQueue();
    private Executor executor = Executors.newSingleThreadExecutor();

    public LogglyAppender() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                while (!LogglyAppender.this.closed) {
                    try {
                        HttpResponse post;
                        String json = (String)LogglyAppender.this.eventQueue.poll(5L, TimeUnit.SECONDS);
                        if (json == null || (post = WS.url((String)LogglyAppender.this.url).timeout(10000).contentType("application/json").body(json).post()).getStatusLine().getStatusCode() == 200) continue;
                        System.err.println("Failed to log to loggly");
                    }
                    catch (Exception e) {
                        System.err.println("Failed to log to loggly");
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public void close() {
        this.closed = true;
    }

    public boolean requiresLayout() {
        return true;
    }

    public void activateOptions() {
        String _url = BASE_URL + this.token;
        if (this.tags != null && !this.tags.isEmpty()) {
            _url = _url + "/tag/" + this.tags;
        }
        this.url = _url + "/";
    }

    protected void append(LoggingEvent event) {
        try {
            String log = this.layout.format(event);
            if (this.layout.ignoresThrowable()) {
                String[] throwableStrRep;
                StringBuilder sb = new StringBuilder(log);
                for (String stack : throwableStrRep = event.getThrowableStrRep()) {
                    sb.append("\n");
                    sb.append(stack);
                }
                log = sb.toString();
            }
            this.eventQueue.put(log);
        }
        catch (InterruptedException e) {
            System.err.println("Failed to append event");
        }
    }
}

