/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.daemon;

import de.taimos.daemon.IDaemonLifecycleListener;
import de.taimos.daemon.LifecyclePhase;
import de.taimos.daemon.properties.CloudConductorPropertyProvider;
import de.taimos.daemon.properties.EmptyPropertyProvider;
import de.taimos.daemon.properties.FilePropertyProvider;
import de.taimos.daemon.properties.IPropertyProvider;
import de.taimos.daemon.properties.SimpleHTTPPropertyProvider;
import de.taimos.daemon.properties.UserDataPropertyProvider;
import java.util.HashMap;
import java.util.Map;

public class DaemonLifecycleAdapter
implements IDaemonLifecycleListener {
    @Override
    public void doStart() throws Exception {
    }

    @Override
    public void doStop() throws Exception {
    }

    @Override
    public void started() {
    }

    @Override
    public void stopped() {
    }

    @Override
    public void stopping() {
    }

    @Override
    public void aborting() {
    }

    @Override
    public void signalUSR2() {
    }

    @Override
    public void exception(LifecyclePhase phase, Throwable exception) {
        System.err.println("Exception in phase: " + phase.name());
        exception.printStackTrace();
    }

    @Override
    public Map<String, String> loadProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.loadBasicProperties(properties);
        properties.putAll(this.getPropertyProvider().loadProperties());
        return properties;
    }

    @Override
    public int getShutdownTimeoutSeconds() {
        return 10;
    }

    protected void loadBasicProperties(Map<String, String> map) {
    }

    public IPropertyProvider getPropertyProvider() {
        switch (System.getProperty("property.source", "")) {
            case "aws": {
                return new UserDataPropertyProvider();
            }
            case "file": {
                return new FilePropertyProvider(System.getProperty("property.location"));
            }
            case "c2": {
                return new CloudConductorPropertyProvider(System.getProperty("property.server"), System.getProperty("property.template"));
            }
            case "http": {
                return new SimpleHTTPPropertyProvider(System.getProperty("property.location"));
            }
        }
        return new EmptyPropertyProvider();
    }
}

