/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.daemon;

import de.taimos.daemon.DaemonManager;
import de.taimos.daemon.IDaemonLifecycleListener;
import de.taimos.daemon.ILoggingConfigurer;
import de.taimos.daemon.LifecyclePhase;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Security;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class DaemonStarter {
    private static final AtomicReference<String> daemonName = new AtomicReference();
    private static final String instanceId = UUID.randomUUID().toString();
    private static final Properties daemonProperties = new Properties();
    private static final AtomicReference<String> hostname = new AtomicReference();
    private static final DaemonManager daemon = new DaemonManager();
    private static final AtomicReference<String> startupMode = new AtomicReference<String>("dev");
    private static final Logger rlog = LoggerFactory.getLogger(DaemonStarter.class);
    private static AtomicReference<ILoggingConfigurer> loggingConfigurer = new AtomicReference();
    private static final AtomicReference<IDaemonLifecycleListener> lifecycleListener = new AtomicReference();
    private static final AtomicReference<LifecyclePhase> currentPhase = new AtomicReference<LifecyclePhase>(LifecyclePhase.STOPPED);

    public static boolean isDevelopmentMode() {
        return startupMode.get().equals("dev");
    }

    public static boolean isStartMode() {
        return startupMode.get().equals("start");
    }

    public static boolean isRunMode() {
        return startupMode.get().equals("run");
    }

    public static String getStartupMode() {
        return startupMode.get();
    }

    public static LifecyclePhase getCurrentPhase() {
        return currentPhase.get();
    }

    public static String getHostname() {
        return hostname.get();
    }

    public static String getDaemonName() {
        return daemonName.get();
    }

    public static String getInstanceId() {
        return instanceId;
    }

    public static Properties getDaemonProperties() {
        return daemonProperties;
    }

    private static IDaemonLifecycleListener getLifecycleListener() {
        if (lifecycleListener == null) {
            throw new RuntimeException("No lifecycle listener found");
        }
        return lifecycleListener.get();
    }

    public static void startDaemon(final String _daemonName, final IDaemonLifecycleListener _lifecycleListener) {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                DaemonStarter.doStartDaemon(_daemonName, _lifecycleListener);
            }
        });
    }

    private static void doStartDaemon(String _daemonName, IDaemonLifecycleListener _lifecycleListener) {
        boolean updated = currentPhase.compareAndSet(LifecyclePhase.STOPPED, LifecyclePhase.STARTING);
        if (!updated) {
            rlog.error("Service already running");
            return;
        }
        daemonName.set(_daemonName);
        DaemonStarter.addProperty("daemonName", _daemonName);
        DaemonStarter.addProperty("serviceName", _daemonName);
        lifecycleListener.set(_lifecycleListener);
        startupMode.set(DaemonStarter.findStartupMode());
        DaemonStarter.configureLogging();
        DaemonStarter.determineHostname();
        DaemonStarter.logStartupInfo();
        DaemonStarter.handleSignals();
        DaemonStarter.initProperties();
        if (DaemonStarter.getDaemonProperties().getProperty("dns.ttl") != null) {
            rlog.info("Setting JVM DNS TTL: " + DaemonStarter.getDaemonProperties().getProperty("dns.ttl"));
            Security.setProperty("networkaddress.cache.ttl", DaemonStarter.getDaemonProperties().getProperty("dns.ttl"));
        }
        try {
            if (loggingConfigurer.get() != null) {
                loggingConfigurer.get().reconfigureLogging();
            }
        }
        catch (Exception e) {
            System.err.println("Logger reconfig failed with exception: " + e.getMessage());
            DaemonStarter.getLifecycleListener().exception(currentPhase.get(), e);
        }
        try {
            DaemonStarter.getLifecycleListener().doStart();
        }
        catch (Exception e) {
            DaemonStarter.abortSystem(e);
        }
        DaemonStarter.notifyStarted();
        daemon.block();
        try {
            DaemonStarter.getLifecycleListener().doStop();
        }
        catch (Exception e) {
            DaemonStarter.abortSystem(e);
        }
        DaemonStarter.notifyStopped();
        System.exit(0);
    }

    private static void configureLogging() {
        String clazz = System.getProperty("loggerConfigurer");
        if (clazz != null) {
            try {
                Class<?> configurerClazz = Class.forName(clazz);
                loggingConfigurer.set((ILoggingConfigurer)configurerClazz.newInstance());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                rlog.warn("No ILoggingConfigurer set");
            }
        }
        try {
            if (loggingConfigurer.get() != null) {
                loggingConfigurer.get().initializeLogging();
            }
        }
        catch (Exception e) {
            System.err.println("Logger config failed with exception: " + e.getMessage());
            DaemonStarter.getLifecycleListener().exception(currentPhase.get(), e);
        }
    }

    private static String findStartupMode() {
        String startmode = System.getProperty("startupMode");
        if (startmode == null) {
            String devmode = System.getProperty("developmentMode");
            if (devmode != null && !devmode.equals("true")) {
                return "start";
            }
            return "dev";
        }
        return startmode;
    }

    private static void notifyStopped() {
        currentPhase.set(LifecyclePhase.STOPPED);
        rlog.info(daemonName + " stopped!");
        DaemonStarter.getLifecycleListener().stopped();
    }

    private static void notifyStarted() {
        currentPhase.set(LifecyclePhase.STARTED);
        rlog.info(daemonName + " started!");
        DaemonStarter.getLifecycleListener().started();
    }

    private static void logStartupInfo() {
        if (DaemonStarter.isDevelopmentMode()) {
            rlog.info("Running in development mode");
        } else {
            rlog.info("Running in production mode: " + startupMode.get());
        }
        rlog.info("Running with instance id: " + instanceId);
        rlog.info("Running on host: " + hostname);
    }

    private static void determineHostname() {
        try {
            String host = InetAddress.getLocalHost().getHostName();
            if (host != null && !host.isEmpty()) {
                hostname.set(host);
            } else {
                rlog.error("Hostname could not be determined --> Exiting");
                DaemonStarter.abortSystem();
            }
        }
        catch (UnknownHostException e) {
            rlog.error("Getting hostname failed", (Throwable)e);
            DaemonStarter.abortSystem(e);
        }
    }

    private static void initProperties() {
        try {
            Map<String, String> properties = DaemonStarter.getLifecycleListener().loadProperties();
            if (properties != null) {
                for (Map.Entry<String, String> e : properties.entrySet()) {
                    DaemonStarter.addProperty(e.getKey(), String.valueOf(e.getValue()));
                }
            }
        }
        catch (Exception e) {
            rlog.error("Getting config data failed", (Throwable)e);
            DaemonStarter.abortSystem(e);
        }
    }

    private static void addProperty(String key, String value) {
        if (key == null) {
            return;
        }
        String trimKey = key.trim();
        if (DaemonStarter.isDevelopmentMode()) {
            rlog.info(String.format("Setting property: '%s' with value '%s'", trimKey, value));
        } else {
            rlog.debug(String.format("Setting property: '%s' with value '%s'", trimKey, value));
        }
        daemonProperties.setProperty(trimKey, value);
        System.setProperty(trimKey, value);
    }

    public static void stopService() {
        currentPhase.set(LifecyclePhase.STOPPING);
        final CountDownLatch cdl = new CountDownLatch(1);
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                DaemonStarter.getLifecycleListener().stopping();
                daemon.stop();
                cdl.countDown();
            }
        });
        try {
            int timeout = lifecycleListener.get().getShutdownTimeoutSeconds();
            if (!cdl.await(timeout, TimeUnit.SECONDS)) {
                rlog.error("Failed to stop gracefully");
                DaemonStarter.abortSystem();
            }
        }
        catch (InterruptedException e) {
            rlog.error("Failure awaiting stop", (Throwable)e);
        }
    }

    private static final void handleSignals() {
        if (DaemonStarter.isStartMode() || DaemonStarter.isRunMode()) {
            try {
                Signal.handle(new Signal("HUP"), new SignalHandler(){

                    @Override
                    public void handle(Signal arg0) {
                        System.out.println("SIG INT");
                    }
                });
            }
            catch (IllegalArgumentException e) {
                System.err.println("Signal HUP not supported");
            }
            try {
                Signal.handle(new Signal("TERM"), new SignalHandler(){

                    @Override
                    public void handle(Signal arg0) {
                        System.out.println("SIG TERM");
                        DaemonStarter.stopService();
                    }
                });
            }
            catch (IllegalArgumentException e) {
                System.err.println("Signal TERM not supported");
            }
            try {
                Signal.handle(new Signal("INT"), new SignalHandler(){

                    @Override
                    public void handle(Signal arg0) {
                        System.out.println("SIG INT");
                        DaemonStarter.stopService();
                    }
                });
            }
            catch (IllegalArgumentException e) {
                System.err.println("Signal INT not supported");
            }
            try {
                Signal.handle(new Signal("USR2"), new SignalHandler(){

                    @Override
                    public void handle(Signal arg0) {
                        System.out.println("SIG USR2");
                        DaemonStarter.getLifecycleListener().signalUSR2();
                    }
                });
            }
            catch (IllegalArgumentException e) {
                System.err.println("Signal USR2 not supported");
            }
        }
    }

    public static void abortSystem() {
        DaemonStarter.abortSystem(null);
    }

    public static void abortSystem(Throwable error) {
        currentPhase.set(LifecyclePhase.ABORTING);
        try {
            DaemonStarter.getLifecycleListener().aborting();
        }
        catch (Exception e) {
            rlog.error("Custom abort failed", (Throwable)e);
        }
        if (error != null) {
            rlog.error("Unrecoverable error encountered  --> Exiting : " + error.getMessage());
            DaemonStarter.getLifecycleListener().exception(LifecyclePhase.ABORTING, error);
        } else {
            rlog.error("Unrecoverable error encountered --> Exiting");
        }
        System.exit(1);
    }
}

