/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.cxf_renderer.model;

import de.taimos.cxf_renderer.model.RenderedUI;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.InternalServerErrorException;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.Log4JLogChute;

public abstract class ViewModel {
    private final String viewName;
    private final Map<String, Object> model = new HashMap<String, Object>();

    private static String evaluateVM(String name, Map<String, Object> variables) {
        try {
            VelocityContext context = new VelocityContext();
            Set<Map.Entry<String, Object>> entrySet = variables.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                context.put(entry.getKey(), entry.getValue());
            }
            Template template = Velocity.getTemplate((String)name);
            StringWriter w = new StringWriter();
            template.merge((Context)context, (Writer)w);
            return w.toString();
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public ViewModel(String viewName) {
        this.viewName = viewName;
    }

    public final String getViewName() {
        return this.viewName;
    }

    public final Map<String, Object> getModel() {
        return this.model;
    }

    public final void addModel(String name, Object value) {
        this.model.put(name, value);
    }

    protected abstract String generateTemplateName();

    public final RenderedUI render() {
        RenderedUI ui = new RenderedUI();
        String templateName = this.generateTemplateName();
        String evaluateVM = ViewModel.evaluateVM(templateName, this.getModel());
        ui.setContent(evaluateVM);
        return ui;
    }

    static {
        try {
            Velocity.setProperty((String)"resource.loader", (Object)"class");
            Velocity.setProperty((String)"class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            Velocity.setProperty((String)"input.encoding", (Object)"UTF-8");
            Velocity.setProperty((String)"output.encoding", (Object)"UTF-8");
            Velocity.setProperty((String)"runtime.log.logsystem.class", (Object)Log4JLogChute.class.getCanonicalName());
            Velocity.setProperty((String)"runtime.log.logsystem.log4j.logger", (Object)"org.apache.velocity");
            Velocity.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

