/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.cxf_renderer.velocity;

import de.taimos.cxf_renderer.model.AbstractViewBodyWriter;
import de.taimos.cxf_renderer.model.ViewModel;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.Log4JLogChute;

public abstract class VelocityBodyWriter
extends AbstractViewBodyWriter {
    private static String evaluateVM(String name, Map<String, Object> variables) {
        try {
            VelocityContext context = new VelocityContext();
            Set<Map.Entry<String, Object>> entrySet = variables.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                context.put(entry.getKey(), entry.getValue());
            }
            Template template = Velocity.getTemplate((String)name);
            StringWriter w = new StringWriter();
            template.merge((Context)context, (Writer)w);
            return w.toString();
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @Override
    protected void write(ViewModel t, MediaType mediaType, OutputStream entityStream) throws IOException, WebApplicationException {
        String templateName = this.generateTemplateName(t.getViewName(), mediaType);
        String evaluate = VelocityBodyWriter.evaluateVM(templateName, t.getModel());
        entityStream.write(evaluate.getBytes());
    }

    protected abstract String generateTemplateName(String var1, MediaType var2);

    @Override
    protected List<MediaType> getMediaTypes() {
        ArrayList<MediaType> r = new ArrayList<MediaType>();
        r.add(MediaType.TEXT_HTML_TYPE);
        r.add(MediaType.TEXT_PLAIN_TYPE);
        return r;
    }

    static {
        try {
            Velocity.setProperty((String)"resource.loader", (Object)"class");
            Velocity.setProperty((String)"class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            Velocity.setProperty((String)"input.encoding", (Object)"UTF-8");
            Velocity.setProperty((String)"output.encoding", (Object)"UTF-8");
            Velocity.setProperty((String)"runtime.log.logsystem.class", (Object)Log4JLogChute.class.getCanonicalName());
            Velocity.setProperty((String)"runtime.log.logsystem.log4j.logger", (Object)"org.apache.velocity");
            Velocity.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

