/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.common.gs1;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.impl.upcean.UPCEANLogicImpl;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;

class GS1Utils {
    GS1Utils() {
    }

    static String addChecksum(String gtin) {
        if (gtin == null || !gtin.matches("[0-9]{12}") && !gtin.matches("[0-9]{7}")) {
            throw new IllegalArgumentException();
        }
        return gtin + UPCEANLogicImpl.calcChecksum((String)gtin);
    }

    static byte[] renderBarcode(AbstractBarcodeBean bean, String message) {
        try {
            BitmapCanvasProvider canvasProvider = new BitmapCanvasProvider(300, 12, false, 0);
            bean.generateBarcode((CanvasProvider)canvasProvider, message);
            canvasProvider.finish();
            BufferedImage image = canvasProvider.getBufferedImage();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", output);
            return output.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new byte[0];
        }
    }
}

