/*
 * Decompiled with CFR 0.152.
 */
package de.syquel.maven.reactorstate.plugin.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class ReactorStatePluginProperties {
    private static final String PROPERTIES_FILENAME = "reactorstate-maven-plugin.properties";
    private static final String PROPERTY_KEY_EXTENSION_ARTIFACT = "extension.artifact";
    private final Artifact extensionArtifact;

    private ReactorStatePluginProperties(Artifact extensionArtifact) {
        this.extensionArtifact = extensionArtifact;
    }

    public static ReactorStatePluginProperties create() throws IOException {
        Properties properties = new Properties();
        try (InputStream propertiesStream = ReactorStatePluginProperties.class.getResourceAsStream(PROPERTIES_FILENAME);){
            properties.load(propertiesStream);
        }
        String artifactCoordinates = properties.getProperty(PROPERTY_KEY_EXTENSION_ARTIFACT);
        DefaultArtifact extensionArtifact = new DefaultArtifact(artifactCoordinates);
        ReactorStatePluginProperties reactorStatePluginProperties = new ReactorStatePluginProperties((Artifact)extensionArtifact);
        return reactorStatePluginProperties;
    }

    public Artifact getExtensionArtifact() {
        return this.getExtensionArtifact(null);
    }

    public Artifact getExtensionArtifact(String classifier) {
        return new DefaultArtifact(this.extensionArtifact.getGroupId(), this.extensionArtifact.getArtifactId(), classifier != null ? classifier : this.extensionArtifact.getClassifier(), this.extensionArtifact.getExtension(), this.extensionArtifact.getVersion());
    }
}

