/*
 * Decompiled with CFR 0.152.
 */
package de.syquel.maven.reactorstate.plugin;

import de.syquel.maven.reactorstate.plugin.config.ReactorStatePluginProperties;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.maven.cli.internal.extension.model.CoreExtension;
import org.apache.maven.cli.internal.extension.model.CoreExtensions;
import org.apache.maven.cli.internal.extension.model.io.xpp3.CoreExtensionsXpp3Reader;
import org.apache.maven.cli.internal.extension.model.io.xpp3.CoreExtensionsXpp3Writer;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;

@Mojo(name="install-local", requiresDirectInvocation=true, threadSafe=true, inheritByDefault=false)
public class ReactorStateInstallLocalMojo
extends AbstractMojo {
    private static final String EXTENSIONS_FILENAME = ".mvn/extensions.xml";
    private final MavenSession mavenSession;

    @Inject
    public ReactorStateInstallLocalMojo(MavenSession mavenSession) {
        this.mavenSession = mavenSession;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Artifact reactorStateExtensionArtifact;
        try {
            ReactorStatePluginProperties properties = ReactorStatePluginProperties.create();
            reactorStateExtensionArtifact = properties.getExtensionArtifact();
        }
        catch (IOException e) {
            throw new MojoFailureException("Cannot determine extension artifact", (Throwable)e);
        }
        CoreExtensions coreExtensions = this.fetchCoreExtensions();
        CoreExtension reactorStateExtension = new CoreExtension();
        reactorStateExtension.setGroupId(reactorStateExtensionArtifact.getGroupId());
        reactorStateExtension.setArtifactId(reactorStateExtensionArtifact.getArtifactId());
        reactorStateExtension.setVersion(reactorStateExtensionArtifact.getVersion());
        for (CoreExtension coreExtension : coreExtensions.getExtensions()) {
            boolean sameGroupId = Objects.equals(reactorStateExtension.getGroupId(), coreExtension.getGroupId());
            boolean sameArtifactId = Objects.equals(reactorStateExtension.getGroupId(), coreExtension.getGroupId());
            if (!sameGroupId || !sameArtifactId) continue;
            this.getLog().info((CharSequence)(ArtifactIdUtils.toId((Artifact)reactorStateExtensionArtifact) + " already registered"));
            return;
        }
        coreExtensions.addExtension(reactorStateExtension);
        this.persistCoreExtensions(coreExtensions);
        this.getLog().info((CharSequence)("Registered " + ArtifactIdUtils.toId((Artifact)reactorStateExtensionArtifact)));
    }

    private CoreExtensions fetchCoreExtensions() throws MojoFailureException {
        CoreExtensions coreExtensions;
        Path projectBaseDir = this.mavenSession.getTopLevelProject().getBasedir().toPath();
        Path mavenExtensionsPath = projectBaseDir.resolve(EXTENSIONS_FILENAME);
        if (Files.notExists(mavenExtensionsPath, new LinkOption[0])) {
            try {
                Files.createDirectories(mavenExtensionsPath.getParent(), new FileAttribute[0]);
                Files.createFile(mavenExtensionsPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot create Maven core extensions", (Throwable)e);
            }
            coreExtensions = new CoreExtensions();
            coreExtensions.setModelEncoding(StandardCharsets.UTF_8.name());
        } else {
            try (BufferedReader mavenExtensionsReader = Files.newBufferedReader(mavenExtensionsPath);){
                coreExtensions = new CoreExtensionsXpp3Reader().read((Reader)mavenExtensionsReader);
            }
            catch (IOException | XmlPullParserException e) {
                throw new MojoFailureException("Cannot read Maven core extensions", e);
            }
        }
        return coreExtensions;
    }

    private void persistCoreExtensions(CoreExtensions coreExtensions) throws MojoFailureException {
        Path projectBaseDir = this.mavenSession.getTopLevelProject().getBasedir().toPath();
        Path mavenExtensionsPath = projectBaseDir.resolve(EXTENSIONS_FILENAME);
        try (BufferedWriter mavenExtensionsWriter = Files.newBufferedWriter(mavenExtensionsPath, new OpenOption[0]);){
            new CoreExtensionsXpp3Writer().write((Writer)mavenExtensionsWriter, coreExtensions);
        }
        catch (IOException e) {
            throw new MojoFailureException("Cannot write Maven core extensions", (Throwable)e);
        }
    }
}

