/*
 * Decompiled with CFR 0.152.
 */
package de.syquel.maven.reactorstate.plugin;

import de.syquel.maven.reactorstate.common.RuntimeReactorStateManager;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="save", requiresDirectInvocation=true, threadSafe=true, inheritByDefault=false, aggregator=true)
public class ReactorStateSaveMojo
extends AbstractMojo {
    private final MavenSession session;

    @Inject
    public ReactorStateSaveMojo(MavenSession session) {
        this.session = session;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.session.getCurrentProject().isExecutionRoot()) {
            return;
        }
        RuntimeReactorStateManager projectStateManager = RuntimeReactorStateManager.create((MavenSession)this.session);
        try {
            projectStateManager.saveProjectStates();
            this.getLog().info((CharSequence)"Saved Maven reactor state");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot save Maven project state", (Exception)e);
        }
    }
}

