/*
 * Decompiled with CFR 0.152.
 */
package de.syquel.maven.reactorstate.plugin;

import de.syquel.maven.reactorstate.common.SavedReactorStateManager;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;

@Mojo(name="restore", requiresDirectInvocation=true, threadSafe=true, inheritByDefault=false, aggregator=true)
public class ReactorStateRestoreMojo
extends AbstractMojo {
    private final MavenSession session;
    private final MavenProjectHelper projectHelper;
    private final ProjectBuilder projectBuilder;

    @Inject
    public ReactorStateRestoreMojo(MavenSession session, MavenProjectHelper projectHelper, ProjectBuilder projectBuilder) {
        this.session = session;
        this.projectHelper = projectHelper;
        this.projectBuilder = projectBuilder;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.session.getCurrentProject().isExecutionRoot()) {
            return;
        }
        try {
            SavedReactorStateManager projectStateManager = SavedReactorStateManager.create((MavenSession)this.session, (ProjectBuilder)this.projectBuilder);
            projectStateManager.restoreProjectStates(this.session, this.projectHelper);
        }
        catch (IOException | ProjectBuildingException e) {
            throw new MojoExecutionException("Cannot restore saved Maven project state", (Exception)e);
        }
    }
}

