/*
 * Decompiled with CFR 0.152.
 */
package de.syquel.maven.reactorstate.common;

import de.syquel.maven.reactorstate.common.AbstractReactorStateManager;
import de.syquel.maven.reactorstate.common.data.MavenArtifactState;
import de.syquel.maven.reactorstate.common.data.MavenProjectState;
import de.syquel.maven.reactorstate.common.persistence.IReactorStateRepository;
import de.syquel.maven.reactorstate.common.persistence.json.JsonReactorStateRepository;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.GroupRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.SnapshotArtifactRepositoryMetadata;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.internal.ArtifactDescriptorUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeReactorStateManager
extends AbstractReactorStateManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeReactorStateManager.class);
    private final IReactorStateRepository reactorStateRepository;

    private RuntimeReactorStateManager(Set<MavenProjectState> projectStates, IReactorStateRepository reactorStateRepository) {
        super(projectStates);
        this.reactorStateRepository = reactorStateRepository;
    }

    public static RuntimeReactorStateManager create(MavenSession mavenSession) {
        HashSet<MavenProjectState> projectStates = new HashSet<MavenProjectState>();
        for (MavenProject project : mavenSession.getProjects()) {
            MavenProjectState projectState = RuntimeReactorStateManager.buildProjectState(project);
            projectStates.add(projectState);
        }
        return new RuntimeReactorStateManager(projectStates, new JsonReactorStateRepository());
    }

    public void saveProjectStates() throws IOException {
        for (MavenProjectState projectState : this.getProjectStates()) {
            this.reactorStateRepository.save(projectState);
        }
    }

    private static MavenProjectState buildProjectState(MavenProject project) {
        MavenArtifactState mainArtifactState = RuntimeReactorStateManager.buildArtifactState(project.getArtifact());
        Artifact pom = ArtifactDescriptorUtils.toPomArtifact((Artifact)mainArtifactState.getArtifact()).setFile(project.getFile());
        Set<MavenArtifactState> attachedArtifactStates = project.getAttachedArtifacts().stream().map(RuntimeReactorStateManager::buildArtifactState).collect(Collectors.toSet());
        MavenProjectState projectState = ArtifactIdUtils.toId((Artifact)mainArtifactState.getArtifact()).equals(ArtifactIdUtils.toId((Artifact)pom)) ? new MavenProjectState(project, pom, new MavenArtifactState(pom), attachedArtifactStates) : new MavenProjectState(project, pom, mainArtifactState, attachedArtifactStates);
        return projectState;
    }

    private static MavenArtifactState buildArtifactState(org.apache.maven.artifact.Artifact repositoryArtifact) {
        MavenArtifactState artifactState = new MavenArtifactState(RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)repositoryArtifact));
        for (ArtifactMetadata artifactMetadata : repositoryArtifact.getMetadataList()) {
            Class<?> artifactMetadataClass = artifactMetadata.getClass();
            if (artifactMetadata instanceof ArtifactRepositoryMetadata) {
                ArtifactRepositoryMetadata artifactRepositoryMetadata = (ArtifactRepositoryMetadata)artifactMetadata;
                artifactState.setArtifactRepositoryMetadata(artifactRepositoryMetadata.getMetadata());
                continue;
            }
            if (artifactMetadata instanceof GroupRepositoryMetadata) {
                GroupRepositoryMetadata groupRepositoryMetadata = (GroupRepositoryMetadata)artifactMetadata;
                artifactState.setGroupRepositoryMetadata(groupRepositoryMetadata.getMetadata());
                continue;
            }
            if (artifactMetadata instanceof SnapshotArtifactRepositoryMetadata) {
                SnapshotArtifactRepositoryMetadata snapshotRepositoryMetadata = (SnapshotArtifactRepositoryMetadata)artifactMetadata;
                artifactState.setSnapshotRepositoryMetadata(snapshotRepositoryMetadata.getMetadata());
                continue;
            }
            if (!(artifactMetadata instanceof RepositoryMetadata)) continue;
            LOGGER.warn("Unknown metadata {} on artifact {}. Ignoring.", (Object)artifactMetadataClass.getName(), (Object)repositoryArtifact.getId());
        }
        return artifactState;
    }
}

