/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.fasterxml.jackson.jr.ob.api.ValueReader;
import com.fasterxml.jackson.jr.ob.impl.BeanPropertyReader;
import com.fasterxml.jackson.jr.ob.impl.JSONReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class BeanReader
extends ValueReader {
    protected final Map<String, BeanPropertyReader> _propsByName;
    protected final Map<String, String> _aliasMapping;
    protected final Set<String> _ignorableNames;
    protected final Constructor<?> _defaultCtor;
    protected final Constructor<?> _stringCtor;
    protected final Constructor<?> _longCtor;

    public BeanReader(Class<?> clazz, Map<String, BeanPropertyReader> map, Constructor<?> constructor, Constructor<?> constructor2, Constructor<?> constructor3, Set<String> set, Map<String, String> map2) {
        super(clazz);
        this._propsByName = map;
        this._defaultCtor = constructor;
        this._stringCtor = constructor2;
        this._longCtor = constructor3;
        if (set == null) {
            set = Collections.emptySet();
        }
        this._ignorableNames = set;
        if (map2 == null) {
            map2 = Collections.emptyMap();
        }
        this._aliasMapping = map2;
    }

    @Deprecated
    public BeanReader(Class<?> clazz, Map<String, BeanPropertyReader> map, Constructor<?> constructor, Constructor<?> constructor2, Constructor<?> constructor3) {
        this(clazz, map, constructor, constructor2, constructor3, null, null);
    }

    public Map<String, BeanPropertyReader> propertiesByName() {
        return this._propsByName;
    }

    public BeanPropertyReader findProperty(String string) {
        BeanPropertyReader beanPropertyReader = this._propsByName.get(string);
        if (beanPropertyReader == null) {
            return this._findAlias(string);
        }
        return beanPropertyReader;
    }

    private final BeanPropertyReader _findAlias(String string) {
        String string2 = this._aliasMapping.get(string);
        return string2 == null ? null : this._propsByName.get(string2);
    }

    @Override
    public Object readNext(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        JsonToken jsonToken = jsonParser.nextToken();
        try {
            switch (jsonToken) {
                case VALUE_NULL: {
                    return null;
                }
                case VALUE_STRING: {
                    return this.create(jsonParser.getText());
                }
                case VALUE_NUMBER_INT: {
                    return this.create(jsonParser.getLongValue());
                }
                case START_OBJECT: {
                    String string;
                    Object object = this.create();
                    while ((string = jsonParser.nextFieldName()) != null) {
                        BeanPropertyReader beanPropertyReader = this.findProperty(string);
                        if (beanPropertyReader == null) {
                            this.handleUnknown(jSONReader, jsonParser, string);
                            continue;
                        }
                        ValueReader valueReader = beanPropertyReader.getReader();
                        beanPropertyReader.setValueFor(object, valueReader.readNext(jSONReader, jsonParser));
                    }
                    if (!jsonParser.hasToken(JsonToken.END_OBJECT)) {
                        throw this._reportProblem(jsonParser);
                    }
                    return object;
                }
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw JSONObjectException.from(jsonParser, "Failed to create an instance of " + this._valueType.getName() + " due to (" + exception.getClass().getName() + "): " + exception.getMessage(), exception);
        }
        throw JSONObjectException.from(jsonParser, "Can not create a " + this._valueType.getName() + " instance out of " + BeanReader._tokenDesc(jsonParser));
    }

    @Override
    public Object read(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        try {
            switch (jsonToken) {
                case VALUE_NULL: {
                    return null;
                }
                case VALUE_STRING: {
                    return this.create(jsonParser.getText());
                }
                case VALUE_NUMBER_INT: {
                    return this.create(jsonParser.getLongValue());
                }
                case START_OBJECT: {
                    String string;
                    Object object = this.create();
                    while ((string = jsonParser.nextFieldName()) != null) {
                        BeanPropertyReader beanPropertyReader = this.findProperty(string);
                        if (beanPropertyReader == null) {
                            this.handleUnknown(jSONReader, jsonParser, string);
                            continue;
                        }
                        Object object2 = beanPropertyReader.getReader().readNext(jSONReader, jsonParser);
                        beanPropertyReader.setValueFor(object, object2);
                    }
                    if (!jsonParser.hasToken(JsonToken.END_OBJECT)) {
                        throw this._reportProblem(jsonParser);
                    }
                    return object;
                }
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw JSONObjectException.from(jsonParser, exception, "Failed to create an instance of %s due to (%s): %s", this._valueType.getName(), exception.getClass().getName(), exception.getMessage());
        }
        throw JSONObjectException.from(jsonParser, "Can not create a %s instance out of %s", this._valueType.getName(), BeanReader._tokenDesc(jsonParser));
    }

    protected Object create() throws Exception {
        if (this._defaultCtor == null) {
            throw new IllegalStateException("Class " + this._valueType.getName() + " does not have default constructor to use");
        }
        return this._defaultCtor.newInstance(new Object[0]);
    }

    protected Object create(String string) throws Exception {
        if (this._stringCtor == null) {
            throw new IllegalStateException("Class " + this._valueType.getName() + " does not have single-String constructor to use");
        }
        return this._stringCtor.newInstance(string);
    }

    protected Object create(long l) throws Exception {
        if (this._longCtor == null) {
            throw new IllegalStateException("Class " + this._valueType.getName() + " does not have single-long constructor to use");
        }
        return this._longCtor.newInstance(l);
    }

    protected void handleUnknown(JSONReader jSONReader, JsonParser jsonParser, String string) throws IOException {
        if (JSON.Feature.FAIL_ON_UNKNOWN_BEAN_PROPERTY.isEnabled(jSONReader._features) && !this._ignorableNames.contains(string)) {
            StringBuilder stringBuilder = new StringBuilder(60);
            Iterator<String> iterator = new TreeSet<String>(this._propsByName.keySet()).iterator();
            if (iterator.hasNext()) {
                stringBuilder.append('\"').append(iterator.next()).append('\"');
                while (iterator.hasNext()) {
                    stringBuilder.append(", \"").append(iterator.next()).append('\"');
                }
            }
            throw JSONObjectException.from(jsonParser, "Unrecognized JSON property \"%s\" for Bean type `%s` (known properties: [%s])", string, this._valueType.getName(), stringBuilder.toString());
        }
        jsonParser.nextToken();
        jsonParser.skipChildren();
    }

    protected IOException _reportProblem(JsonParser jsonParser) {
        return JSONObjectException.from(jsonParser, "Unexpected token " + (Object)((Object)jsonParser.currentToken()) + "; should get FIELD_NAME or END_OBJECT");
    }
}

