/*
 * Decompiled with CFR 0.152.
 */
package de.syquel.maven.reactorstate.extension.workspacereader;

import de.syquel.maven.reactorstate.common.SavedReactorStateManager;
import de.syquel.maven.reactorstate.common.data.MavenArtifactState;
import de.syquel.maven.reactorstate.common.data.MavenProjectState;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="ide")
@Singleton
public class ReactorStateWorkspaceReader
extends AbstractMavenLifecycleParticipant
implements WorkspaceReader {
    public static final String WORKSPACE_READER_IDE_QUALIFIER = "ide";
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactorStateWorkspaceReader.class);
    private final ProjectBuilder projectBuilder;
    private final WorkspaceRepository repository = new WorkspaceRepository();
    private final Map<String, Artifact> artifactLookupMap = new HashMap<String, Artifact>();

    @Inject
    public ReactorStateWorkspaceReader(ProjectBuilder projectBuilder) {
        this.projectBuilder = projectBuilder;
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        SavedReactorStateManager projectStateManager;
        try {
            projectStateManager = SavedReactorStateManager.create((MavenSession)session, (ProjectBuilder)this.projectBuilder);
        }
        catch (IOException | ProjectBuildingException e) {
            throw new MavenExecutionException("Cannot acquire saved reactor state", e);
        }
        for (MavenProjectState projectState : projectStateManager.getProjectStates()) {
            this.add(projectState.getPom());
            this.add(projectState.getMainArtifactState().getArtifact());
            for (MavenArtifactState attachedArtifactState : projectState.getAttachedArtifactStates()) {
                this.add(attachedArtifactState.getArtifact());
            }
        }
    }

    public WorkspaceRepository getRepository() {
        return this.repository;
    }

    public File findArtifact(Artifact artifact) {
        Artifact lookedupArtifact = this.artifactLookupMap.get(ArtifactIdUtils.toVersionlessId((Artifact)artifact));
        if (ArtifactIdUtils.equalsBaseId((Artifact)artifact, (Artifact)lookedupArtifact)) {
            return lookedupArtifact.getFile();
        }
        return null;
    }

    public List<String> findVersions(Artifact artifact) {
        Artifact lookedupArtifact = this.artifactLookupMap.get(ArtifactIdUtils.toVersionlessId((Artifact)artifact));
        if (ArtifactIdUtils.equalsBaseId((Artifact)artifact, (Artifact)lookedupArtifact)) {
            return Collections.singletonList(lookedupArtifact.getVersion());
        }
        return Collections.emptyList();
    }

    private void add(Artifact artifact) {
        this.artifactLookupMap.put(ArtifactIdUtils.toVersionlessId((Artifact)artifact), artifact);
    }
}

