/*
 * Decompiled with CFR 0.152.
 */
package de.syquel.maven.reactorstate.extension;

import de.syquel.maven.reactorstate.common.RuntimeReactorStateManager;
import de.syquel.maven.reactorstate.common.SavedReactorStateManager;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="reactorstate-save")
@Singleton
public class ReactorStateSaveExtension
extends AbstractMavenLifecycleParticipant {
    public static final String EXTENSION_ID = "reactorstate-save";
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactorStateSaveExtension.class);
    private final MavenProjectHelper projectHelper;
    private final ProjectBuilder projectBuilder;

    @Inject
    public ReactorStateSaveExtension(MavenProjectHelper projectHelper, ProjectBuilder projectBuilder) {
        this.projectHelper = projectHelper;
        this.projectBuilder = projectBuilder;
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        try {
            SavedReactorStateManager projectStateManager = SavedReactorStateManager.create(session, this.projectBuilder);
            if (projectStateManager.getProjectStates().isEmpty()) {
                return;
            }
            projectStateManager.restoreProjectStates(session, this.projectHelper);
        }
        catch (IOException | ProjectBuildingException e) {
            throw new MavenExecutionException("Cannot restore saved Maven project state", e);
        }
    }

    public void afterSessionEnd(MavenSession session) throws MavenExecutionException {
        LOGGER.info("Saving state of Maven session");
        RuntimeReactorStateManager projectStateManager = RuntimeReactorStateManager.create(session);
        try {
            projectStateManager.saveProjectStates();
        }
        catch (IOException e) {
            throw new MavenExecutionException("Cannot save reactor state", (Throwable)e);
        }
    }
}

