/*
 * Decompiled with CFR 0.152.
 */
package de.syquel.maven.reactorstate.common;

import de.syquel.maven.reactorstate.common.AbstractReactorStateManager;
import de.syquel.maven.reactorstate.common.data.MavenArtifactState;
import de.syquel.maven.reactorstate.common.data.MavenProjectState;
import de.syquel.maven.reactorstate.common.persistence.json.JsonReactorStateRepository;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.GroupRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.SnapshotArtifactRepositoryMetadata;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.eclipse.aether.artifact.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SavedReactorStateManager
extends AbstractReactorStateManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SavedReactorStateManager.class);

    private SavedReactorStateManager(Set<MavenProjectState> projectStates) {
        super(projectStates);
    }

    public static SavedReactorStateManager create(MavenSession session, ProjectBuilder projectBuilder) throws ProjectBuildingException, IOException {
        HashSet<MavenProject> projects = new HashSet<MavenProject>(session.getProjects());
        LOGGER.info("Resolving Maven project tree");
        SavedReactorStateManager.contributeWorkspaceProjects(session.getCurrentProject(), projects, session.getProjectBuildingRequest(), projectBuilder);
        JsonReactorStateRepository reactorStateRepository = new JsonReactorStateRepository();
        HashSet<MavenProjectState> projectStates = new HashSet<MavenProjectState>();
        for (MavenProject project : projects) {
            MavenProjectState projectState = reactorStateRepository.read(project);
            if (projectState == null) continue;
            projectStates.add(projectState);
        }
        return new SavedReactorStateManager(projectStates);
    }

    public void restoreProjectStates(MavenSession session, MavenProjectHelper projectHelper) {
        HashSet projects = new HashSet(session.getProjects());
        for (MavenProject project : projects) {
            MavenProjectState projectState = this.getProjectState(project);
            if (projectState == null) {
                throw new IllegalStateException("No saved state found for Maven project " + project.getId() + ": Rebuild required.");
            }
            project.setPomFile(projectState.getPom().getFile());
            MavenArtifactState mainArtifactState = projectState.getMainArtifactState();
            org.apache.maven.artifact.Artifact mainArtifact = SavedReactorStateManager.buildArtifact(mainArtifactState);
            project.getArtifact().setFile(mainArtifact.getFile());
            LOGGER.info("Restored main artifact {}", (Object)mainArtifact.getId());
            Collection attachedArtifacts = projectState.getAttachedArtifactStates().stream().map(SavedReactorStateManager::buildArtifact).collect(Collectors.toList());
            project.getAttachedArtifacts().clear();
            for (org.apache.maven.artifact.Artifact attachedArtifact : attachedArtifacts) {
                projectHelper.attachArtifact(project, attachedArtifact.getType(), attachedArtifact.getClassifier(), attachedArtifact.getFile());
                LOGGER.info("Restored attached artifact {}", (Object)attachedArtifact.getId());
            }
        }
    }

    private static void contributeWorkspaceProjects(MavenProject project, Set<MavenProject> discoveredProjects, ProjectBuildingRequest buildingRequest, ProjectBuilder projectBuilder) throws ProjectBuildingException {
        Path projectBasePath = project.getBasedir().toPath();
        for (String module : project.getModules()) {
            Path modulePomPath = projectBasePath.resolve(module).resolve("pom.xml");
            MavenProject moduleProject = projectBuilder.build(modulePomPath.toFile(), buildingRequest).getProject();
            if (discoveredProjects.contains(moduleProject)) continue;
            LOGGER.info("Discovered upstream Maven project {}", (Object)moduleProject.getId());
            discoveredProjects.add(moduleProject);
            SavedReactorStateManager.contributeWorkspaceProjects(moduleProject, discoveredProjects, buildingRequest, projectBuilder);
        }
        MavenProject parentProject = project.getParent();
        if (parentProject != null && !discoveredProjects.contains(parentProject) && SavedReactorStateManager.isWorkspaceProject(parentProject)) {
            LOGGER.info("Discovered Maven parent project {}", (Object)parentProject.getId());
            discoveredProjects.add(parentProject);
            SavedReactorStateManager.contributeWorkspaceProjects(parentProject, discoveredProjects, buildingRequest, projectBuilder);
        }
    }

    private static boolean isWorkspaceProject(MavenProject project) {
        return project.getBasedir() != null;
    }

    private static org.apache.maven.artifact.Artifact buildArtifact(MavenArtifactState artifactState) {
        org.apache.maven.artifact.Artifact repositoryArtifact = RepositoryUtils.toArtifact((Artifact)artifactState.getArtifact());
        if (artifactState.getArtifactRepositoryMetadata() != null) {
            ArtifactRepositoryMetadata artifactRepositoryMetadata = new ArtifactRepositoryMetadata(repositoryArtifact);
            artifactRepositoryMetadata.setMetadata(artifactState.getArtifactRepositoryMetadata());
            repositoryArtifact.addMetadata((ArtifactMetadata)artifactRepositoryMetadata);
        }
        if (artifactState.getGroupRepositoryMetadata() != null) {
            GroupRepositoryMetadata groupRepositoryMetadata = new GroupRepositoryMetadata(artifactState.getGroupRepositoryMetadata().getGroupId());
            groupRepositoryMetadata.setMetadata(artifactState.getGroupRepositoryMetadata());
            repositoryArtifact.addMetadata((ArtifactMetadata)groupRepositoryMetadata);
        }
        if (artifactState.getSnapshotRepositoryMetadata() != null) {
            SnapshotArtifactRepositoryMetadata snapshotRepositoryMetadata = new SnapshotArtifactRepositoryMetadata(repositoryArtifact);
            snapshotRepositoryMetadata.setMetadata(artifactState.getSnapshotRepositoryMetadata());
            repositoryArtifact.addMetadata((ArtifactMetadata)snapshotRepositoryMetadata);
        }
        return repositoryArtifact;
    }
}

