/*
 * Decompiled with CFR 0.152.
 */
package de.syquel.maven.reactorstate.extension.workspacereader;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.aether.util.repository.ChainedWorkspaceReader;
import org.eclipse.sisu.Priority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="ide")
@Singleton
@Priority(value=0x7FFFFFFF)
public class DelegatingIdeWorkspaceReader
extends AbstractMavenLifecycleParticipant
implements WorkspaceReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatingIdeWorkspaceReader.class);
    private final PlexusContainer plexusContainer;
    private ChainedWorkspaceReader delegate = new ChainedWorkspaceReader(new WorkspaceReader[0]);

    @Inject
    public DelegatingIdeWorkspaceReader(PlexusContainer plexusContainer) {
        this.plexusContainer = plexusContainer;
    }

    public void afterSessionStart(MavenSession session) throws MavenExecutionException {
        Map workspaceReaders;
        try {
            workspaceReaders = this.plexusContainer.lookupMap(WorkspaceReader.class);
        }
        catch (ComponentLookupException e) {
            throw new MavenExecutionException("No workspace readers registered", (Throwable)e);
        }
        ArrayList<WorkspaceReader> ideWorkspaceReaders = new ArrayList<WorkspaceReader>();
        for (Map.Entry workspaceReaderEntry : workspaceReaders.entrySet()) {
            WorkspaceReader workspaceReader;
            String workspaceReaderQualifier = (String)workspaceReaderEntry.getKey();
            if (!"ide".equals(workspaceReaderQualifier) || (workspaceReader = (WorkspaceReader)workspaceReaderEntry.getValue()) == this) continue;
            LOGGER.info("Register workspace reader {}", (Object)workspaceReader.getRepository().getId());
            ideWorkspaceReaders.add(workspaceReader);
        }
        this.delegate = new ChainedWorkspaceReader(ideWorkspaceReaders.toArray(new WorkspaceReader[0]));
    }

    public File findArtifact(Artifact artifact) {
        return this.delegate.findArtifact(artifact);
    }

    public List<String> findVersions(Artifact artifact) {
        return this.delegate.findVersions(artifact);
    }

    public WorkspaceRepository getRepository() {
        return this.delegate.getRepository();
    }
}

