/*
 * Decompiled with CFR 0.152.
 */
package de.syquel.maven.reactorstate.common.persistence.json;

import com.fasterxml.jackson.jr.ob.JSON;
import de.syquel.maven.reactorstate.common.MavenProjectState;
import de.syquel.maven.reactorstate.common.persistence.IReactorStateRepository;
import de.syquel.maven.reactorstate.common.persistence.json.dto.ArtifactDto;
import de.syquel.maven.reactorstate.common.persistence.json.dto.MavenProjectStateDto;
import de.syquel.maven.reactorstate.common.util.MavenProjectUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;

public class JsonReactorStateRepository
implements IReactorStateRepository {
    private static final String STATE_PROPERTIES_FILENAME = "reactorstate-maven.json";

    @Override
    public MavenProjectState read(MavenProject mavenProject) throws IOException {
        MavenProjectStateDto dto;
        Path reactorStatePath = JsonReactorStateRepository.getReactorStatePath(mavenProject);
        if (!Files.isReadable(reactorStatePath)) {
            return null;
        }
        JSON objectMapper = JsonReactorStateRepository.buildObjectMapper();
        try (BufferedReader reactorStateReader = Files.newBufferedReader(reactorStatePath);){
            dto = objectMapper.beanFrom(MavenProjectStateDto.class, reactorStateReader);
        }
        MavenProjectState projectState = JsonReactorStateRepository.convert(mavenProject, dto);
        return projectState;
    }

    @Override
    public void save(MavenProjectState mavenProjectState) throws IOException {
        Path reactorStatePath = JsonReactorStateRepository.getReactorStatePath(mavenProjectState.getProject());
        if (!Files.isDirectory(reactorStatePath.getParent(), new LinkOption[0])) {
            Files.createDirectories(reactorStatePath.getParent(), new FileAttribute[0]);
        }
        MavenProjectStateDto dto = JsonReactorStateRepository.convert(mavenProjectState);
        JSON objectMapper = JsonReactorStateRepository.buildObjectMapper();
        try (BufferedWriter reactorStateWriter = Files.newBufferedWriter(reactorStatePath, new OpenOption[0]);){
            objectMapper.write((Object)dto, reactorStateWriter);
        }
    }

    @Override
    public void delete(MavenProject mavenProject) throws IOException {
        Path reactorStatePath = JsonReactorStateRepository.getReactorStatePath(mavenProject);
        Files.deleteIfExists(reactorStatePath);
    }

    private static MavenProjectState convert(MavenProject mavenProject, MavenProjectStateDto mavenProjectStateDto) {
        Path projectBasePath = mavenProject.getBasedir().toPath();
        Artifact pom = JsonReactorStateRepository.convert(mavenProjectStateDto.getPom(), projectBasePath);
        Artifact mainArtifact = JsonReactorStateRepository.convert(mavenProjectStateDto.getMainArtifact(), projectBasePath);
        Set<Artifact> attachedArtifacts = mavenProjectStateDto.getAttachedArtifacts().stream().map(artifactDto -> JsonReactorStateRepository.convert(artifactDto, projectBasePath)).collect(Collectors.toSet());
        MavenProjectState mavenProjectState = new MavenProjectState(mavenProject, pom, mainArtifact, attachedArtifacts);
        return mavenProjectState;
    }

    private static Artifact convert(ArtifactDto artifactDto, Path projectBasePath) {
        File artifactFile = artifactDto.getPath() != null ? projectBasePath.resolve(artifactDto.getPath()).toFile() : null;
        Artifact artifact = new DefaultArtifact(artifactDto.getCoordinates(), artifactDto.getProperties()).setFile(artifactFile);
        return artifact;
    }

    private static MavenProjectStateDto convert(MavenProjectState projectState) {
        String projectId = projectState.getProject().getId();
        Path projectBasePath = projectState.getProject().getBasedir().toPath();
        ArtifactDto pomDto = JsonReactorStateRepository.convert(projectState.getPom(), projectBasePath);
        ArtifactDto mainArtifactDto = JsonReactorStateRepository.convert(projectState.getMainArtifact(), projectBasePath);
        Set<ArtifactDto> attachedArtifactDtos = projectState.getAttachedArtifacts().stream().map(artifact -> JsonReactorStateRepository.convert(artifact, projectBasePath)).collect(Collectors.toSet());
        MavenProjectStateDto projectStateDto = new MavenProjectStateDto(projectId, pomDto, mainArtifactDto, attachedArtifactDtos);
        return projectStateDto;
    }

    private static ArtifactDto convert(Artifact artifact, Path projectBasePath) {
        String artifactCoordinates = ArtifactIdUtils.toId((Artifact)artifact);
        File artifactFile = artifact.getFile();
        String artifactPath = artifactFile != null ? projectBasePath.relativize(artifactFile.toPath()).toString() : null;
        ArtifactDto artifactDto = new ArtifactDto(artifactCoordinates, artifactPath, artifact.getProperties());
        return artifactDto;
    }

    private static Path getReactorStatePath(MavenProject mavenProject) {
        Path projectBuildPath = MavenProjectUtils.resolveProjectBuildPath(mavenProject);
        Path reactorStatePath = projectBuildPath.resolve(STATE_PROPERTIES_FILENAME);
        return reactorStatePath;
    }

    private static JSON buildObjectMapper() {
        return JSON.builder().enable(JSON.Feature.PRETTY_PRINT_OUTPUT, JSON.Feature.WRITE_NULL_PROPERTIES, JSON.Feature.READ_ONLY).disable(JSON.Feature.USE_DEFERRED_MAPS).build();
    }
}

