/*
 * Decompiled with CFR 0.152.
 */
package de.syquel.maven.reactorstate.common;

import de.syquel.maven.reactorstate.common.AbstractReactorStateManager;
import de.syquel.maven.reactorstate.common.MavenProjectState;
import de.syquel.maven.reactorstate.common.persistence.IReactorStateRepository;
import de.syquel.maven.reactorstate.common.persistence.json.JsonReactorStateRepository;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.internal.ArtifactDescriptorUtils;
import org.eclipse.aether.artifact.Artifact;

public class RuntimeReactorStateManager
extends AbstractReactorStateManager {
    private final IReactorStateRepository reactorStateRepository;

    private RuntimeReactorStateManager(Set<MavenProjectState> projectStates, IReactorStateRepository reactorStateRepository) {
        super(projectStates);
        this.reactorStateRepository = reactorStateRepository;
    }

    public static RuntimeReactorStateManager create(MavenSession mavenSession) {
        HashSet<MavenProjectState> projectStates = new HashSet<MavenProjectState>();
        for (MavenProject project : mavenSession.getProjects()) {
            MavenProjectState projectState = RuntimeReactorStateManager.buildProjectState(project);
            projectStates.add(projectState);
        }
        return new RuntimeReactorStateManager(projectStates, new JsonReactorStateRepository());
    }

    public void saveProjectStates() throws IOException {
        for (MavenProjectState projectState : this.getProjectStates()) {
            this.reactorStateRepository.save(projectState);
        }
    }

    private static MavenProjectState buildProjectState(MavenProject project) {
        Artifact mainArtifact = RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)project.getArtifact());
        Artifact pom = ArtifactDescriptorUtils.toPomArtifact((Artifact)mainArtifact).setFile(project.getFile());
        HashSet<Artifact> attachedArtifacts = new HashSet<Artifact>(RepositoryUtils.toArtifacts((Collection)project.getAttachedArtifacts()));
        MavenProjectState projectState = "pom".equals(mainArtifact.getExtension()) ? new MavenProjectState(project, pom, pom, attachedArtifacts) : new MavenProjectState(project, pom, mainArtifact, attachedArtifacts);
        return projectState;
    }
}

