/*
 * Decompiled with CFR 0.152.
 */
package de.swm.mobile.kitchensink.generator;

import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import de.swm.mobile.kitchensink.client.ShowcaseAnnotations;
import de.swm.mobile.kitchensink.client.base.ShowcaseDetailPage;
import de.swm.mobile.kitchensink.generator.Templates;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;

public class ShowcaseGenerator
extends Generator {
    private ClassLoader classLoader = null;
    private GeneratorContext context = null;
    private TreeLogger logger = null;
    private Set<String> rawFiles = new HashSet();

    public String generate(TreeLogger logger, GeneratorContext context, String typeName) throws UnableToCompleteException {
        JClassType[] types;
        this.logger = logger;
        this.context = context;
        this.classLoader = Thread.currentThread().getContextClassLoader();
        if (!this.isFirstPass()) {
            return null;
        }
        JClassType cwType = null;
        try {
            cwType = context.getTypeOracle().getType(ShowcaseDetailPage.class.getName());
        }
        catch (NotFoundException e) {
            logger.log(TreeLogger.ERROR, "Cannot find ContentWidget class", (Throwable)e);
            throw new UnableToCompleteException();
        }
        for (JClassType type : types = cwType.getSubtypes()) {
            this.generateUiXMLFiles(type);
            this.generateSourceFiles(type);
        }
        return null;
    }

    private void createPublicResource(String partialPath, String contents) throws UnableToCompleteException {
        try {
            OutputStream outStream = this.context.tryCreateResource(this.logger, partialPath);
            if (outStream == null) {
                String message = "Attempting to generate duplicate public resource: " + partialPath + ".\nAll generated source files must have unique names.";
                this.logger.log(TreeLogger.ERROR, message);
                throw new UnableToCompleteException();
            }
            outStream.write(contents.getBytes());
            this.context.commitResource(this.logger, outStream);
        }
        catch (IOException e) {
            this.logger.log(TreeLogger.ERROR, "Error writing file: " + partialPath, (Throwable)e);
            throw new UnableToCompleteException();
        }
    }

    private void generateUiXMLFiles(JClassType type) throws UnableToCompleteException {
        String[] filenames;
        if (!type.isAnnotationPresent(ShowcaseAnnotations.ShowcaseUiXML.class)) {
            return;
        }
        String pkgName = type.getPackage().getName();
        String pkgPath = pkgName.replace('.', '/') + "/";
        for (String filename : filenames = ((ShowcaseAnnotations.ShowcaseUiXML)type.getAnnotation(ShowcaseAnnotations.ShowcaseUiXML.class)).value()) {
            String path = pkgName + filename;
            if (this.rawFiles.contains(path)) continue;
            this.rawFiles.add(path);
            String fileContents = this.getResourceContents(pkgPath + filename);
            fileContents = fileContents.replace("<", "&lt;");
            fileContents = fileContents.replace(">", "&gt;");
            fileContents = fileContents.replace("* \n   */\n", "*/\n");
            fileContents = "<pre>" + fileContents + "</pre>";
            StringBuilder sb = new StringBuilder();
            sb.append(Templates.getPrefixXML());
            sb.append(fileContents);
            sb.append(Templates.getSuffix());
            String dstPath = "swmMobileSource/uixml/" + filename + ".html";
            this.createPublicResource(dstPath, sb.toString());
        }
    }

    private void generateSourceFiles(JClassType type) throws UnableToCompleteException {
        String filename = type.getQualifiedSourceName().replace('.', '/') + ".java";
        String fileContents = this.getResourceContents(filename);
        String formattedSource = "";
        String sourceTag = "@" + ShowcaseAnnotations.ShowcaseSource.class.getSimpleName();
        int srcTagIndex = fileContents.indexOf(sourceTag);
        if (srcTagIndex >= 0) {
            formattedSource = formattedSource + fileContents + "\n\n";
        }
        formattedSource = formattedSource.replace("<", "&lt;");
        formattedSource = formattedSource.replace(">", "&gt;");
        formattedSource = formattedSource.replace("* \n   */\n", "*/\n");
        formattedSource = "<pre>" + formattedSource + "</pre>";
        StringBuilder sb = new StringBuilder();
        sb.append(Templates.getPrefixJava());
        sb.append(formattedSource);
        sb.append(Templates.getSuffix());
        String dstPath = "swmMobileSource/java/" + type.getSimpleSourceName() + ".html";
        this.createPublicResource(dstPath, sb.toString());
    }

    private String getResourceContents(String path) throws UnableToCompleteException {
        InputStream in = this.classLoader.getResourceAsStream(path);
        if (in == null) {
            this.logger.log(TreeLogger.ERROR, "Resource not found: " + path);
            throw new UnableToCompleteException();
        }
        StringBuilder fileContentsBuf = new StringBuilder();
        BufferedReader br = null;
        try {
            String temp;
            br = new BufferedReader(new InputStreamReader(in));
            while ((temp = br.readLine()) != null) {
                fileContentsBuf.append(temp).append('\n');
            }
        }
        catch (IOException e) {
            this.logger.log(TreeLogger.ERROR, "Cannot read resource", (Throwable)e);
            throw new UnableToCompleteException();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
        return fileContentsBuf.toString();
    }

    private boolean isFirstPass() {
        String placeholder = "swmMobileSource/generated";
        try {
            OutputStream outStream = this.context.tryCreateResource(this.logger, placeholder);
            if (outStream == null) {
                return false;
            }
            this.context.commitResource(this.logger, outStream);
        }
        catch (UnableToCompleteException e) {
            this.logger.log(TreeLogger.ERROR, "Unable to generate", (Throwable)e);
            return false;
        }
        return true;
    }
}

