/*
 * Decompiled with CFR 0.152.
 */
package de.swingbe.ifleet.parser;

import de.swingbe.ifleet.model.TelegramHdr;
import de.swingbe.ifleet.parser.TelegramHdrParser;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TelegramHdrParserImpl
implements TelegramHdrParser {
    private static final Logger LOG = LoggerFactory.getLogger(TelegramHdrParserImpl.class);

    TelegramHdrParserImpl() {
    }

    public static boolean isNumeric(String str) {
        return str != null && str.matches("[0-9.]+");
    }

    @Override
    public TelegramHdr parse(String input) {
        TelegramHdr teleHeader = null;
        String[] splits = input.split("#");
        String type = null;
        if (splits.length > 0) {
            type = splits[0];
        }
        String version = null;
        if (splits.length > 1) {
            version = splits[1];
        }
        String id = null;
        if (splits.length > 2) {
            id = splits[2];
        }
        if (type != null && version != null && id != null) {
            boolean typeIsNumeric = TelegramHdrParserImpl.isNumeric(type);
            boolean idIsNumeric = TelegramHdrParserImpl.isNumeric(id);
            if (typeIsNumeric && idIsNumeric) {
                try {
                    teleHeader = new TelegramHdr(Integer.parseInt(type), version, Integer.parseInt(id));
                }
                catch (NumberFormatException e) {
                    LOG.error("parsing telegram header failed, message: " + e.getMessage() + ", trace: " + Arrays.toString(e.getStackTrace()));
                }
            }
        }
        return teleHeader;
    }
}

