/*
 * Decompiled with CFR 0.152.
 */
package de.swingbe.ifleet.parser;

import de.swingbe.ifleet.model.Position;
import de.swingbe.ifleet.parser.PositionParser;
import de.swingbe.ifleet.parser.TelegramHdrParserImpl;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionParserImpl
implements PositionParser {
    private static final Logger LOG = LoggerFactory.getLogger(PositionParserImpl.class);

    @Override
    public Position parse(String input) {
        Position position = null;
        String[] splits = input.split("#");
        String lat = null;
        if (splits.length > 2) {
            lat = splits[2];
        }
        String lon = null;
        if (splits.length > 3) {
            lon = splits[3];
        }
        String vel = null;
        if (splits.length > 4) {
            vel = splits[4];
        }
        String hdg = null;
        if (splits.length > 5) {
            hdg = splits[5];
        }
        if (lat != null && lon != null && vel != null && hdg != null) {
            boolean latIsNumeric = TelegramHdrParserImpl.isNumeric(lat);
            boolean lonIsNumeric = TelegramHdrParserImpl.isNumeric(lon);
            boolean velIsNumeric = TelegramHdrParserImpl.isNumeric(vel);
            boolean hdgIsNumeric = TelegramHdrParserImpl.isNumeric(hdg);
            if (latIsNumeric && lonIsNumeric && velIsNumeric && hdgIsNumeric) {
                try {
                    position = new Position(Long.parseLong(lat), Long.parseLong(lon), Integer.parseInt(vel), Integer.parseInt(hdg));
                }
                catch (NumberFormatException e) {
                    LOG.error("parsing position failed, message: " + e.getMessage() + ", trace: " + Arrays.toString(e.getStackTrace()));
                }
            }
        }
        return position;
    }
}

