/*
 * Decompiled with CFR 0.152.
 */
package de.swingbe.ifleet.parser;

import de.swingbe.ifleet.model.Communication;
import de.swingbe.ifleet.model.Header;
import de.swingbe.ifleet.model.Telegram;
import de.swingbe.ifleet.parser.ComParser;
import de.swingbe.ifleet.parser.HeaderParserFactory;
import de.swingbe.ifleet.parser.TelegramParserFactory;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ComParserImpl
implements ComParser {
    private static final Logger LOG = LoggerFactory.getLogger(ComParserImpl.class);
    private static final String SEP = "#";
    private static final String END = System.getProperty("line.separator");

    ComParserImpl() {
    }

    public static String popFieldFromCom(String com, int numberOfFields) {
        String comNew = com;
        String comSup = null;
        for (int i = 0; i < numberOfFields; ++i) {
            if (comNew != null) {
                int indexChar = comNew.indexOf(35);
                try {
                    comSup = comNew.substring(indexChar + 1);
                }
                catch (IndexOutOfBoundsException e) {
                    LOG.error("poping field from communication failed, message: " + e.getMessage() + ", trace: " + Arrays.toString(e.getStackTrace()));
                }
                comNew = comSup;
                continue;
            }
            LOG.error("input unavailable");
        }
        return comNew;
    }

    @Override
    public Communication parse(String input) {
        Communication com = null;
        Header header = null;
        Telegram telegram = null;
        if (input.contains("<")) {
            String inputSup = input.substring(input.indexOf("<") + 1, input.lastIndexOf(">"));
            header = HeaderParserFactory.createHeaderParser().parse(input);
            String inputSupPop = ComParserImpl.popFieldFromCom(inputSup, 4);
            telegram = TelegramParserFactory.createTelegramParser().parse(inputSupPop);
        } else {
            LOG.warn("telegram NOT included");
        }
        if (telegram != null && header != null) {
            com = new Communication(header, telegram);
        } else {
            LOG.warn("telegram NOT available");
        }
        return com;
    }
}

