/*
 * Decompiled with CFR 0.152.
 */
package mangoo.io.testing;

import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mangoo.io.configuration.Config;
import mangoo.io.core.Application;
import mangoo.io.enums.ContentType;
import mangoo.io.enums.Default;
import mangoo.io.enums.Key;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MangooResponse {
    private static final Logger LOG = LoggerFactory.getLogger(MangooResponse.class);
    private String responseUrl;
    private String responseUri;
    private HttpString responseMethod;
    private String responseContent;
    private HttpResponse httpResponse;
    private ContentType responseContentType;
    private String responseRequestBody;
    private boolean responseDisbaleRedirects;
    private List<NameValuePair> postParameter = new ArrayList<NameValuePair>();
    private CookieStore cookieStore = new BasicCookieStore();
    private HttpClient httpClient;
    private HttpClient httpClientNoRedirects;
    private Map<String, String> headers = new HashMap<String, String>();

    public MangooResponse(String string, HttpString httpString) {
        this.responseUri = string;
        this.responseMethod = httpString;
        this.init();
    }

    public MangooResponse() {
        this.init();
    }

    private void init() {
        Config config = (Config)Application.getInjector().getInstance(Config.class);
        String string = config.getString(Key.APPLICATION_HOST, Default.APPLICATION_HOST.toString());
        int n = config.getInt(Key.APPLICATION_PORT, Default.APPLICATION_PORT.toInt());
        this.responseUrl = "http://" + string + ":" + n;
        this.httpClient = HttpClientBuilder.create().setDefaultCookieStore(this.cookieStore).build();
        this.httpClientNoRedirects = HttpClientBuilder.create().setDefaultCookieStore(this.cookieStore).disableRedirectHandling().build();
    }

    public MangooResponse contentType(ContentType contentType) {
        this.responseContentType = contentType;
        return this;
    }

    public MangooResponse requestBody(String string) {
        this.responseRequestBody = string;
        return this;
    }

    public MangooResponse postParameters(List<NameValuePair> list) {
        this.postParameter = list;
        return this;
    }

    public MangooResponse disableRedirects(boolean bl) {
        this.responseDisbaleRedirects = bl;
        return this;
    }

    public MangooResponse uri(String string) {
        this.responseUri = string;
        return this;
    }

    public MangooResponse header(String string, String string2) {
        this.headers.put(string, string2);
        return this;
    }

    public MangooResponse method(HttpString httpString) {
        this.responseMethod = httpString;
        return this;
    }

    public MangooResponse execute() {
        if (this.responseMethod.equals(Methods.GET)) {
            HttpGet httpGet = new HttpGet(this.responseUrl + this.responseUri);
            return this.doRequest((HttpUriRequest)httpGet);
        }
        if (this.responseMethod.equals(Methods.POST)) {
            HttpPost httpPost = new HttpPost(this.responseUrl + this.responseUri);
            try {
                if (StringUtils.isNotBlank((CharSequence)this.responseRequestBody)) {
                    httpPost.setEntity((HttpEntity)new StringEntity(this.responseRequestBody));
                } else {
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(this.postParameter));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LOG.error("Failed to create HttpPost request", (Throwable)unsupportedEncodingException);
            }
            return this.doRequest((HttpUriRequest)httpPost);
        }
        return this;
    }

    private MangooResponse doRequest(HttpUriRequest httpUriRequest) {
        if (this.responseContentType != null) {
            httpUriRequest.setHeader("Content-Type", this.responseContentType.toString());
        }
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            httpUriRequest.setHeader(entry.getKey(), entry.getValue());
        }
        try {
            this.httpResponse = this.responseDisbaleRedirects ? this.httpClientNoRedirects.execute(httpUriRequest) : this.httpClient.execute(httpUriRequest);
            this.responseContent = EntityUtils.toString((HttpEntity)this.httpResponse.getEntity());
        }
        catch (IOException iOException) {
            LOG.error("Failed to execute request to " + this.responseUrl, (Throwable)iOException);
        }
        return this;
    }

    public String getContent() {
        return this.responseContent;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public int getStatusCode() {
        return this.httpResponse.getStatusLine().getStatusCode();
    }

    public List<Cookie> getCookies() {
        return this.cookieStore.getCookies() == null ? new ArrayList() : this.cookieStore.getCookies();
    }

    public String getContentType() {
        return this.httpResponse.getEntity().getContentType().getValue();
    }
}

